/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab;

import edu.colorado.phet.capacitorlab.CLGlobalProperties;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModule;
import edu.colorado.phet.capacitorlab.module.introduction.IntroductionModule;
import edu.colorado.phet.capacitorlab.module.multiplecapacitors.MultipleCapacitorsModule;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBoxMenuItem;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JSeparator;

public class CapacitorLabApplication
extends PiccoloPhetApplication {
    public static final PhetResources RESOURCES = new PhetResources("capacitor-lab");

    public CapacitorLabApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        CLGlobalProperties cLGlobalProperties = new CLGlobalProperties(this.getPhetFrame(), this.isDeveloperControlsEnabled());
        this.initModules(cLGlobalProperties);
        this.initMenuBar(cLGlobalProperties);
    }

    private void initModules(CLGlobalProperties cLGlobalProperties) {
        this.addModule(new IntroductionModule(cLGlobalProperties));
        this.addModule(new DielectricModule(cLGlobalProperties));
        this.addModule(new MultipleCapacitorsModule(cLGlobalProperties));
        int n = 0;
        for (Module module : this.getModules()) {
            n = Math.max(n, module.getControlPanel().getPreferredSize().width);
        }
        for (Module module : this.getModules()) {
            module.getControlPanel().addControlFullWidth(Box.createHorizontalStrut(n));
        }
    }

    private void initMenuBar(CLGlobalProperties cLGlobalProperties) {
        JMenu jMenu = this.getPhetFrame().getDeveloperMenu();
        jMenu.add(new JSeparator());
        jMenu.add(new PropertyCheckBoxMenuItem("Show E-Field measurement shapes", cLGlobalProperties.eFieldShapesVisibleProperty));
        jMenu.add(new PropertyCheckBoxMenuItem("Show voltage measurement shapes", cLGlobalProperties.voltageShapesVisibleProperty));
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, "capacitor-lab", CapacitorLabApplication.class);
    }
}

