/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PAffineTransformException;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import edu.umd.cs.piccolox.pswing.PSwingEvent;
import edu.umd.cs.piccolox.pswing.PSwingMouseEvent;
import edu.umd.cs.piccolox.pswing.PSwingMouseWheelEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class PSwingEventHandler
implements PInputEventListener {
    private PNode listenNode = null;
    private boolean active = false;
    private Component previousComponent = null;
    private Point2D prevPoint = null;
    private Point2D previousOffset = null;
    private boolean recursing = false;
    private final ButtonData leftButtonData = new ButtonData();
    private final ButtonData middleButtonData = new ButtonData();
    private final ButtonData rightButtonData = new ButtonData();
    private final PSwingCanvas canvas;

    public PSwingEventHandler(PSwingCanvas pSwingCanvas, PNode pNode) {
        this.canvas = pSwingCanvas;
        this.listenNode = pNode;
    }

    void setActive(boolean bl) {
        if (this.active && !bl) {
            if (this.listenNode != null) {
                this.active = false;
                this.listenNode.removeInputEventListener(this);
            }
        } else if (!this.active && bl && this.listenNode != null) {
            this.active = true;
            this.listenNode.addInputEventListener(this);
        }
    }

    private Component findShowingComponentAt(Component component, int n, int n2) {
        Container container;
        Component component2;
        if (!component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container && (component2 = this.findShowingChildAt(container = (Container)component, n, n2)) != null) {
            return component2;
        }
        return component;
    }

    private Component findShowingChildAt(Container container, int n, int n2) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == null) continue;
            Point point = component.getLocation();
            if ((component = component instanceof Container ? this.findShowingComponentAt(component, n - point.x, n2 - point.y) : component.getComponentAt(n - point.x, n2 - point.y)) == null || !component.isShowing()) continue;
            return component;
        }
        return null;
    }

    void dispatchEvent(PSwingEvent pSwingEvent, PInputEvent pInputEvent) {
        Object object;
        Serializable serializable;
        MouseEvent mouseEvent = pSwingEvent.asMouseEvent();
        PNode pNode = pSwingEvent.getPath().getPickedNode();
        PNode pNode2 = pSwingEvent.getCurrentNode();
        Component component = null;
        Point point = null;
        Point point2 = new Point();
        if (pNode2 instanceof PSwing && pNode.isDescendentOf(this.canvas.getRoot())) {
            serializable = (PSwing)pNode2;
            object = pNode;
            point = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.cameraToLocal(pSwingEvent.getPath().getTopCamera(), point, (PNode)object);
            this.prevPoint = (Point)point.clone();
            component = this.findShowingComponentAt(((PSwing)serializable).getComponent(), point.x, point.y);
            if (component != null && component != ((PSwing)serializable).getComponent()) {
                point2 = this.extractSwingOffset(component, (PSwing)serializable);
            }
            if (component != null && this.isMousePress(pSwingEvent)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.leftButtonData.setState(pNode, component, point2.x, point2.y);
                } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    this.middleButtonData.setState(pNode, component, point2.x, point2.y);
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.rightButtonData.setState(pNode, component, point2.x, point2.y);
                }
            }
        }
        if (this.isDragOrRelease(pSwingEvent)) {
            if (this.isLeftMouseButtonOnComponent(mouseEvent)) {
                this.handleButton(pSwingEvent, pInputEvent, this.leftButtonData);
            }
            if (this.isMiddleMouseButtonOnComponent(mouseEvent)) {
                this.handleButton(pSwingEvent, pInputEvent, this.middleButtonData);
            }
            if (this.isRightMouseButtonOnComponent(mouseEvent)) {
                this.handleButton(pSwingEvent, pInputEvent, this.rightButtonData);
            }
        } else if (this.isPressOrClickOrMove(pSwingEvent) && component != null) {
            serializable = new MouseEvent(component, pSwingEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x - point2.x, point.y - point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            object = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable).getID(), (MouseEvent)serializable, pInputEvent);
            this.dispatchEvent(component, (PSwingEvent)object);
        } else if (this.isWheelEvent(pSwingEvent) && component != null) {
            serializable = (MouseWheelEvent)mouseEvent;
            object = new MouseWheelEvent(component, pSwingEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x - point2.x, point.y - point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)serializable).getScrollType(), ((MouseWheelEvent)serializable).getScrollAmount(), ((MouseWheelEvent)serializable).getWheelRotation());
            PSwingMouseWheelEvent pSwingMouseWheelEvent = new PSwingMouseWheelEvent(((AWTEvent)object).getID(), (MouseWheelEvent)object, pInputEvent);
            this.dispatchEvent(component, pSwingMouseWheelEvent);
        }
        if (this.previousComponent != null) {
            if (component == null || pSwingEvent.getID() == 505) {
                serializable = this.createExitEvent(mouseEvent);
                object = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable).getID(), (MouseEvent)serializable, pInputEvent);
                this.dispatchEvent(this.previousComponent, (PSwingEvent)object);
                this.previousComponent = null;
            } else if (this.previousComponent != component) {
                serializable = this.createExitEvent(mouseEvent);
                object = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable).getID(), (MouseEvent)serializable, pInputEvent);
                this.dispatchEvent(this.previousComponent, (PSwingEvent)object);
                serializable = this.createEnterEvent(component, mouseEvent, point2.x, point2.y);
                object = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable).getID(), (MouseEvent)serializable, pInputEvent);
                component.dispatchEvent(object.asMouseEvent());
            }
        } else if (component != null) {
            serializable = this.createEnterEvent(component, mouseEvent, point2.x, point2.y);
            object = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable).getID(), (MouseEvent)serializable, pInputEvent);
            this.dispatchEvent(component, (PSwingEvent)object);
        }
        this.previousComponent = component;
        if (component != null) {
            this.previousOffset = point2;
        }
    }

    private Point extractSwingOffset(Component component, PSwing pSwing) {
        int n = 0;
        int n2 = 0;
        for (Component component2 = component; component2 != pSwing.getComponent(); component2 = component2.getParent()) {
            n += component2.getLocation().x;
            n2 += component2.getLocation().y;
        }
        return new Point(n, n2);
    }

    private boolean isRightMouseButtonOnComponent(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent) && this.rightButtonData.getFocusedComponent() != null;
    }

    private boolean isMiddleMouseButtonOnComponent(MouseEvent mouseEvent) {
        return SwingUtilities.isMiddleMouseButton(mouseEvent) && this.middleButtonData.getFocusedComponent() != null;
    }

    private boolean isLeftMouseButtonOnComponent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && this.leftButtonData.getFocusedComponent() != null;
    }

    private boolean isMousePress(PSwingEvent pSwingEvent) {
        return pSwingEvent.getID() == 501;
    }

    private boolean isWheelEvent(PSwingEvent pSwingEvent) {
        return pSwingEvent.getID() == 507;
    }

    private boolean isPressOrClickOrMove(PSwingEvent pSwingEvent) {
        return this.isMousePress(pSwingEvent) || pSwingEvent.getID() == 500 || pSwingEvent.getID() == 503;
    }

    private boolean isDragOrRelease(PSwingEvent pSwingEvent) {
        return pSwingEvent.getID() == 506 || pSwingEvent.getID() == 502;
    }

    private MouseEvent createEnterEvent(Component component, MouseEvent mouseEvent, int n, int n2) {
        return new MouseEvent(component, 504, mouseEvent.getWhen(), 0, (int)this.prevPoint.getX() - n, (int)this.prevPoint.getY() - n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    private MouseEvent createExitEvent(MouseEvent mouseEvent) {
        return new MouseEvent(this.previousComponent, 505, mouseEvent.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.previousOffset.getX(), (int)this.prevPoint.getY() - (int)this.previousOffset.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    private void handleButton(PSwingEvent pSwingEvent, PInputEvent pInputEvent, ButtonData buttonData) {
        MouseEvent mouseEvent = pSwingEvent.asMouseEvent();
        if (this.involvesSceneNode(buttonData)) {
            Point2D.Double double_ = new Point2D.Double(mouseEvent.getX(), mouseEvent.getY());
            this.cameraToLocal(pSwingEvent.getPath().getTopCamera(), double_, buttonData.getPNode());
            MouseEvent mouseEvent2 = new MouseEvent(buttonData.getFocusedComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)((Point2D)double_).getX() - buttonData.getOffsetX(), (int)((Point2D)double_).getY() - buttonData.getOffsetY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            PSwingEvent pSwingEvent2 = PSwingMouseEvent.createMouseEvent(mouseEvent2.getID(), mouseEvent2, pInputEvent);
            this.dispatchEvent(buttonData.getFocusedComponent(), pSwingEvent2);
        } else {
            this.dispatchEvent(buttonData.getFocusedComponent(), pSwingEvent);
        }
        mouseEvent.consume();
        if (pSwingEvent.getID() == 502) {
            buttonData.mouseReleased();
        }
    }

    private boolean involvesSceneNode(ButtonData buttonData) {
        return buttonData.getPNode().isDescendentOf(this.canvas.getRoot());
    }

    private void dispatchEvent(final Component component, final PSwingEvent pSwingEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.dispatchEvent(pSwingEvent.asMouseEvent());
            }
        });
    }

    private void cameraToLocal(PCamera pCamera, Point2D point2D, PNode pNode) {
        if (pNode != null) {
            if (this.descendsFromLayer(pNode)) {
                AffineTransform affineTransform = this.invertTransform(pCamera.getViewTransform());
                affineTransform.transform(point2D, point2D);
            }
            pNode.globalToLocal(point2D);
        }
    }

    private boolean descendsFromLayer(PNode pNode) {
        PNode pNode2 = pNode;
        while (pNode2 != null) {
            if (!((pNode2 = pNode2.getParent()) instanceof PLayer)) continue;
            return true;
        }
        return false;
    }

    private AffineTransform invertTransform(PAffineTransform pAffineTransform) {
        try {
            return pAffineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new PAffineTransformException(noninvertibleTransformException, pAffineTransform);
        }
    }

    public void processEvent(PInputEvent pInputEvent, int n) {
        if (!pInputEvent.isMouseEvent()) {
            return;
        }
        InputEvent inputEvent = pInputEvent.getSourceSwingEvent();
        if (!(inputEvent instanceof MouseEvent)) {
            throw new RuntimeException("PInputEvent.getSourceSwingEvent was not a MouseEvent.  Actual event: " + inputEvent + ", class=" + inputEvent.getClass().getName());
        }
        this.processMouseEvent(pInputEvent, (MouseEvent)inputEvent);
    }

    private void processMouseEvent(PInputEvent pInputEvent, MouseEvent mouseEvent) {
        if (!this.recursing) {
            this.recursing = true;
            PSwingEvent pSwingEvent = PSwingMouseEvent.createMouseEvent(mouseEvent.getID(), mouseEvent, pInputEvent);
            this.dispatchEvent(pSwingEvent, pInputEvent);
            if (pSwingEvent.asMouseEvent().isConsumed()) {
                pInputEvent.setHandled(true);
            }
            this.recursing = false;
        }
    }

    private static class ButtonData {
        private PNode focusNode = null;
        private Component focusComponent = null;
        private int focusOffX = 0;
        private int focusOffY = 0;

        private ButtonData() {
        }

        public void setState(PNode pNode, Component component, int n, int n2) {
            this.focusComponent = component;
            this.focusNode = pNode;
            this.focusOffX = n;
            this.focusOffY = n2;
        }

        public Component getFocusedComponent() {
            return this.focusComponent;
        }

        public PNode getPNode() {
            return this.focusNode;
        }

        public int getOffsetX() {
            return this.focusOffX;
        }

        public int getOffsetY() {
            return this.focusOffY;
        }

        public void mouseReleased() {
            this.focusComponent = null;
            this.focusNode = null;
        }
    }
}

