/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

public class PrecisionDecimal {
    private final int numberOfDecimalPlaces;
    private double preciseValue;
    private double value;

    public PrecisionDecimal(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numberOfDecimalPlaces must be >= 0");
        }
        this.numberOfDecimalPlaces = n;
        this.setValue(d);
    }

    private static double adjustPrecision(double d, int n) {
        int n2 = d >= 0.0 ? 1 : -1;
        double d2 = Math.pow(10.0, n);
        return (double)((long)n2 * Math.round(Math.abs(d) * d2)) / d2;
    }

    public int getNumberOfDecimalPlaces() {
        return this.numberOfDecimalPlaces;
    }

    public void setValue(double d) {
        this.preciseValue = d;
        this.value = PrecisionDecimal.adjustPrecision(d, this.numberOfDecimalPlaces);
    }

    public double getValue() {
        return this.value;
    }

    public double getPreciseValue() {
        return this.preciseValue;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof PrecisionDecimal) {
            PrecisionDecimal precisionDecimal = (PrecisionDecimal)object;
            bl = precisionDecimal.getValue() == this.getValue();
        }
        return bl;
    }
}

