/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.games;

import edu.colorado.phet.common.games.GameConstants;
import edu.colorado.phet.common.games.GameSettings;
import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.constant.Constable;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class GameSettingsPanel
extends GridPanel {
    private static final Border BORDER = new LineBorder(Color.BLACK, 1);
    private static final Color BACKGROUND_FILL_COLOR = new Color(180, 205, 255);
    private final VoidFunction0 cleanupFunction;
    private final GridPanel inputPanel;
    private int inputRow;
    public static final Color DEFAULT_BUTTON_COLOR = new Color(235, 235, 235);

    public GameSettingsPanel(GameSettings gameSettings, VoidFunction0 voidFunction0) {
        this(gameSettings, voidFunction0, new PhetFont(24), new PhetFont(), new PhetFont(), DEFAULT_BUTTON_COLOR);
    }

    public GameSettingsPanel(GameSettings gameSettings, final VoidFunction0 voidFunction0, PhetFont phetFont, PhetFont phetFont2, PhetFont phetFont3, final Color color) {
        PropertyRadioButton<Constable> propertyRadioButton;
        this.setBorder(BORDER);
        this.setBackground(BACKGROUND_FILL_COLOR);
        JLabel jLabel = new JLabel(GameConstants.TITLE_GAME_SETTINGS);
        jLabel.setFont(phetFont);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setForeground(Color.BLACK);
        JLabel jLabel2 = new JLabel(GameConstants.LABEL_LEVEL_CONTROL);
        jLabel2.setFont(phetFont2);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        final ArrayList<PropertyRadioButton<Integer>> arrayList = new ArrayList<PropertyRadioButton<Integer>>();
        jPanel.setOpaque(false);
        for (int i = gameSettings.level.getMin(); i <= gameSettings.level.getMax(); ++i) {
            propertyRadioButton = new PropertyRadioButton<Integer>(UserComponentChain.chain((IUserComponent)GameSimSharing.UserComponents.levelRadioButton, i), String.valueOf(i), gameSettings.level, i);
            propertyRadioButton.setFont(phetFont3);
            propertyRadioButton.setOpaque(false);
            arrayList.add(propertyRadioButton);
            jPanel.add(propertyRadioButton);
        }
        JLabel jLabel3 = new JLabel(new ImageIcon(GameConstants.STOPWATCH_ICON));
        jLabel3.setFont(phetFont2);
        propertyRadioButton = new PropertyRadioButton<Boolean>(GameSimSharing.UserComponents.timerOnRadioButton, GameConstants.RADIO_BUTTON_ON, gameSettings.timerEnabled, true);
        propertyRadioButton.setFont(phetFont3);
        propertyRadioButton.setOpaque(false);
        final PropertyRadioButton<Boolean> propertyRadioButton2 = new PropertyRadioButton<Boolean>(GameSimSharing.UserComponents.timerOffRadioButton, GameConstants.RADIO_BUTTON_OFF, gameSettings.timerEnabled, false);
        propertyRadioButton2.setFont(phetFont3);
        propertyRadioButton2.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(propertyRadioButton);
        buttonGroup.add(propertyRadioButton2);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setOpaque(false);
        jPanel2.add(propertyRadioButton);
        jPanel2.add(propertyRadioButton2);
        JLabel jLabel4 = new JLabel(new ImageIcon(GameConstants.SOUND_ICON));
        jLabel4.setFont(phetFont2);
        final PropertyRadioButton<Boolean> propertyRadioButton3 = new PropertyRadioButton<Boolean>(GameSimSharing.UserComponents.soundOnRadioButton, GameConstants.RADIO_BUTTON_ON, gameSettings.soundEnabled, true);
        propertyRadioButton3.setFont(phetFont3);
        propertyRadioButton3.setOpaque(false);
        final PropertyRadioButton<Boolean> propertyRadioButton4 = new PropertyRadioButton<Boolean>(GameSimSharing.UserComponents.soundOffRadioButton, GameConstants.RADIO_BUTTON_OFF, gameSettings.soundEnabled, false);
        propertyRadioButton4.setFont(phetFont3);
        propertyRadioButton4.setOpaque(false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(propertyRadioButton3);
        buttonGroup2.add(propertyRadioButton4);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setOpaque(false);
        jPanel3.add(propertyRadioButton3);
        jPanel3.add(propertyRadioButton4);
        this.inputPanel = new GridPanel();
        this.inputPanel.setOpaque(false);
        this.inputPanel.setInsets(new Insets(3, 5, 3, 5));
        this.inputRow = 0;
        this.addControl(jLabel2, jPanel);
        this.addControl(jLabel3, jPanel2);
        this.addControl(jLabel4, jPanel3);
        JSeparator jSeparator2 = new JSeparator();
        jSeparator2.setForeground(Color.BLACK);
        PhetPCanvas phetPCanvas = new PhetPCanvas(){
            {
                this.addScreenChild(new HTMLImageButtonNode(GameConstants.BUTTON_START){
                    {
                        this.setUserComponent(GameSimSharing.UserComponents.startGameButton);
                        this.setBackground(color);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                voidFunction0.apply();
                            }
                        });
                        this.setPreferredSize(new Dimension((int)this.getFullBounds().getWidth() + this.getShadowOffset(), (int)this.getFullBounds().getHeight() + this.getShadowOffset()));
                    }
                });
                this.setBackground(BACKGROUND_FILL_COLOR);
                this.setBorder(null);
            }
        };
        int n = 0;
        int n2 = 0;
        this.setInsets(new Insets(6, 5, 0, 5));
        this.add((Component)jLabel, n++, n2);
        this.add((Component)jSeparator, n++, n2, GridPanel.Fill.HORIZONTAL);
        this.setInsets(new Insets(3, 5, 3, 5));
        this.add((Component)this.inputPanel, n++, n2);
        this.add((Component)jSeparator2, n++, n2, GridPanel.Fill.HORIZONTAL);
        this.setInsets(new Insets(3, 5, 6, 5));
        this.add((Component)phetPCanvas, n++, n2);
        this.cleanupFunction = new VoidFunction0(){

            public void apply() {
                for (PropertyRadioButton propertyRadioButton5 : arrayList) {
                    propertyRadioButton5.cleanup();
                }
                propertyRadioButton.cleanup();
                propertyRadioButton2.cleanup();
                propertyRadioButton3.cleanup();
                propertyRadioButton4.cleanup();
            }
        };
    }

    public void addControl(Component component, Component component2) {
        this.inputPanel.add(component, this.inputRow, 0, GridPanel.Anchor.EAST);
        this.inputPanel.add(component2, this.inputRow++, 1, GridPanel.Anchor.WEST);
    }
}

