/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.IConfigurableAtomModel;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.CellFactory;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.DefaultCellFactory;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.ElementCell;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.PeriodicTableAtom;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.PeriodicTableNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class PeriodicTableControlNode
extends PNode {
    public Color backgroundColor = null;

    public PeriodicTableControlNode(final IConfigurableAtomModel iConfigurableAtomModel, final int n, Color color) {
        final IDynamicAtom iDynamicAtom = iConfigurableAtomModel.getAtom();
        PeriodicTableNode periodicTableNode = new PeriodicTableNode(color, new CellFactory(){

            public ElementCell createCellForElement(int n2, Color color) {
                if (n2 <= n) {
                    return new ButtonElementCell(iDynamicAtom, n2, iConfigurableAtomModel);
                }
                return new DefaultCellFactory().createCellForElement(n2, color);
            }
        });
        this.addChild(periodicTableNode);
    }

    private static class ButtonElementCell
    extends ElementCell {
        private static final Paint IDLE_PAINT = new GradientPaint(0.0f, 10.0f, new Color(220, 220, 220), 0.0f, 20.0f, new Color(180, 180, 180));
        private static final Paint FOCUSED_PAINT = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), 0.0f, 20.0f, new Color(200, 200, 200));
        private static final Paint PRESSED_PAINT = new GradientPaint(0.0f, 0.0f, new Color(170, 170, 170), 0.0f, 20.0f, new Color(210, 210, 210));
        private static final Paint SELECTED_PAINT = Color.WHITE;
        private static final Stroke IDLE_STROKE = new BasicStroke(1.0f);
        private static final Stroke SELECTED_STROKE = new BasicStroke(2.0f);
        private final Font LABEL_FONT = new PhetFont(12);
        private final PPath buttonNode;
        private final PText text;
        private PeriodicTableAtom atom;

        public ButtonElementCell(final PeriodicTableAtom periodicTableAtom, final int n, final IConfigurableAtomModel iConfigurableAtomModel) {
            super(n);
            this.atom = periodicTableAtom;
            this.addInputEventListener(new CursorHandler());
            this.buttonNode = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0), IDLE_PAINT, IDLE_STROKE, Color.BLACK);
            this.addChild(this.buttonNode);
            ButtonEventHandler buttonEventHandler = new ButtonEventHandler(){
                {
                    this.addButtonEventListener(new ButtonEventHandler.ButtonEventAdapter(){
                        boolean focus = false;

                        public void setFocus(boolean bl) {
                            boolean bl2;
                            this.focus = bl;
                            boolean bl3 = bl2 = periodicTableAtom.getNumProtons() == n;
                            if (bl2) {
                                ButtonElementCell.this.buttonNode.setPaint(SELECTED_PAINT);
                            } else {
                                ButtonElementCell.this.buttonNode.setPaint(bl ? FOCUSED_PAINT : IDLE_PAINT);
                            }
                        }

                        public void setArmed(boolean bl) {
                            if (periodicTableAtom.getNumProtons() == n) {
                                ButtonElementCell.this.buttonNode.setPaint(SELECTED_PAINT);
                            } else if (bl) {
                                ButtonElementCell.this.buttonNode.setPaint(PRESSED_PAINT);
                            } else {
                                ButtonElementCell.this.buttonNode.setPaint(this.focus ? FOCUSED_PAINT : IDLE_PAINT);
                            }
                        }

                        public void fire() {
                            if (periodicTableAtom.getNumProtons() != n) {
                                iConfigurableAtomModel.setAtomConfiguration(AtomIdentifier.getMostCommonIsotope(ButtonElementCell.this.getAtomicNumber()));
                            }
                        }
                    });
                }
            };
            this.buttonNode.addInputEventListener(buttonEventHandler);
            this.text = new PText(AtomIdentifier.getSymbol(n)){
                {
                    this.setFont(ButtonElementCell.this.LABEL_FONT);
                }
            };
            double d = this.buttonNode.getFullBoundsReference().width;
            this.text.setPickable(false);
            if (this.text.getFullBoundsReference().width >= d || this.text.getFullBoundsReference().height >= d) {
                this.text.setScale(Math.min(d / this.text.getFullBoundsReference().width, d / this.text.getFullBoundsReference().height));
            }
            this.text.centerFullBoundsOnPoint(d / 2.0, d / 2.0);
            this.buttonNode.addChild(this.text);
            periodicTableAtom.addAtomListener(new VoidFunction0(){

                public void apply() {
                    ButtonElementCell.this.updateSelected();
                }
            });
            this.updateSelected();
        }

        public void updateSelected() {
            boolean bl = this.atom.getNumProtons() == this.getAtomicNumber();
            this.text.setFont(new PhetFont(PhetFont.getDefaultFontSize(), bl));
            if (bl) {
                this.buttonNode.setPaint(SELECTED_PAINT);
                this.buttonNode.setStroke(SELECTED_STROKE);
                this.buttonNode.setStrokePaint(PhetColorScheme.RED_COLORBLIND);
                this.moveToFront();
            } else {
                this.buttonNode.setPaint(IDLE_PAINT);
                this.buttonNode.setStroke(IDLE_STROKE);
                this.buttonNode.setStrokePaint(Color.BLACK);
            }
        }
    }
}

