/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MaximizeControlNode
extends PhetPNode {
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Color BACKGROUND_FILL_COLOR = null;
    private static final Color LABEL_PAINT = Color.BLACK;
    private static final Font LABEL_FONT = new PhetFont(18, true);
    private final PDimension maximizedSize;
    private final PDimension minimizedSize;
    private final PNode managedNode;
    private final PPath backgroundNode;
    private final PImage buttonNode;
    private final ArrayList<ChangeListener> listeners;
    private boolean isMaximized;

    public MaximizeControlNode(String string, PDimension pDimension, PNode pNode, boolean bl) {
        this.managedNode = pNode;
        this.isMaximized = bl;
        this.listeners = new ArrayList();
        this.backgroundNode = new PPath();
        this.backgroundNode.setStroke(BACKGROUND_STROKE);
        this.backgroundNode.setStrokePaint(BACKGROUND_STROKE_COLOR);
        this.backgroundNode.setPaint(BACKGROUND_FILL_COLOR);
        this.addChild(this.backgroundNode);
        this.buttonNode = new PImage(PhetCommonResources.getImage("buttons/maximizeButton.png"));
        this.buttonNode.scale(1.25);
        this.buttonNode.addInputEventListener(new CursorHandler());
        this.buttonNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                MaximizeControlNode.this.setMaximized(!MaximizeControlNode.this.isMaximized);
            }
        });
        this.addChild(this.buttonNode);
        PText pText = new PText(string);
        pText.setTextPaint(LABEL_PAINT);
        pText.setFont(LABEL_FONT);
        this.addChild(pText);
        double d = 15.0;
        double d2 = 6.0;
        this.buttonNode.setOffset(pDimension.getWidth() - this.buttonNode.getFullBoundsReference().width - d, d2);
        d2 = this.buttonNode.getFullBoundsReference().getCenterY() - pText.getFullBoundsReference().getHeight() / 2.0;
        d = pDimension.width / 2.0 - pText.getFullBoundsReference().width / 2.0;
        pText.setOffset(d, d2);
        this.maximizedSize = new PDimension(pDimension.getWidth(), pDimension.getHeight());
        double d3 = Math.max(this.buttonNode.getFullBoundsReference().getHeight(), pText.getFullBoundsReference().getHeight()) + 12.0;
        this.minimizedSize = new PDimension(pDimension.getWidth(), d3);
        this.isMaximized = !bl;
        this.setMaximized(bl);
    }

    public void setMaximized(boolean bl) {
        if (bl != this.isMaximized) {
            this.isMaximized = bl;
            if (this.isMaximized) {
                this.buttonNode.setImage(PhetCommonResources.getImage("buttons/minimizeButton.png"));
                this.backgroundNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.maximizedSize.getWidth(), this.maximizedSize.getHeight()));
                this.addChild(this.managedNode);
            } else {
                this.buttonNode.setImage(PhetCommonResources.getImage("buttons/maximizeButton.png"));
                this.backgroundNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.minimizedSize.getWidth(), this.minimizedSize.getHeight()));
                this.removeChild(this.managedNode);
            }
            this.fireActionPerformed();
        }
    }

    private void fireActionPerformed() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

