/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;

public class IonIndicatorNode
extends PNode {
    private static final Font ATOM_ION_FONT = new PhetFont(28, true);

    public IonIndicatorNode(final IDynamicAtom iDynamicAtom, final BooleanProperty booleanProperty, final double d) {
        this.addChild(new PText(BuildAnAtomStrings.POSITIVE_ION){
            {
                super(string);
                this.setFont(ATOM_ION_FONT);
                this.setTextPaint(Color.blue);
                final AtomListener.Adapter adapter = new AtomListener.Adapter(){

                    public void configurationChanged() {
                        this.setVisible((Boolean)booleanProperty.get() != false && iDynamicAtom.getNumProtons() > 0);
                        if (iDynamicAtom.getCharge() > 0) {
                            this.setText(BuildAnAtomStrings.POSITIVE_ION);
                            this.setTextPaint(Color.red);
                        } else if (iDynamicAtom.getCharge() < 0) {
                            this.setText(BuildAnAtomStrings.NEGATIVE_ION);
                            this.setTextPaint(Color.blue);
                        } else {
                            this.setText(BuildAnAtomStrings.NEUTRAL_ATOM);
                            this.setTextPaint(Color.black);
                        }
                        this.setScale(1.0);
                        if (this.getFullBounds().getWidth() > d) {
                            this.scale(d / this.getFullBounds().getWidth());
                        }
                    }
                };
                iDynamicAtom.addAtomListener(adapter);
                booleanProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        adapter.configurationChanged();
                    }
                });
            }
        });
    }
}

