/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.BuildAnAtomModel;
import edu.colorado.phet.buildanatom.modules.game.view.InteractiveSchematicAtomNode;
import edu.colorado.phet.buildanatom.view.ChargeIndicatorNode;
import edu.colorado.phet.buildanatom.view.ElementNameIndicator;
import edu.colorado.phet.buildanatom.view.HighlightingPeriodicTable;
import edu.colorado.phet.buildanatom.view.IonIndicatorNode;
import edu.colorado.phet.buildanatom.view.MassIndicatorNode;
import edu.colorado.phet.buildanatom.view.MaximizeControlNode;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.buildanatom.view.OrbitalViewControl;
import edu.colorado.phet.buildanatom.view.ParticleCountLegend;
import edu.colorado.phet.buildanatom.view.StabilityIndicator;
import edu.colorado.phet.buildanatom.view.SymbolIndicatorNode;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JCheckBox;

public class BuildAnAtomCanvas
extends PhetPCanvas
implements Resettable {
    private final BuildAnAtomModel model;
    private final PNode rootNode;
    private final PNode particleLayer;
    private final PNode indicatorLayer;
    private final ModelViewTransform mvt;
    private final Property<OrbitalView> orbitalViewProperty = new Property<OrbitalView>(OrbitalView.PARTICLES);
    private final BooleanProperty showName = new BooleanProperty(true);
    private final BooleanProperty showNeutralIon = new BooleanProperty(true);
    private final BooleanProperty showStableUnstable = new BooleanProperty(true);
    private final MaximizeControlNode elementIndicatorWindow;
    private final MaximizeControlNode symbolWindow;
    private final MaximizeControlNode massWindow;
    private final MaximizeControlNode chargeWindow;

    public BuildAnAtomCanvas(BuildAnAtomModel buildAnAtomModel) {
        this.model = buildAnAtomModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, BuildAnAtomDefaults.STAGE_SIZE));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.width * 0.3), (int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.height * 0.45)), 2.0);
        this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        this.indicatorLayer = new PNode();
        this.rootNode.addChild(this.indicatorLayer);
        this.particleLayer = new PNode();
        this.rootNode.addChild(this.particleLayer);
        this.particleLayer.addChild(new InteractiveSchematicAtomNode(buildAnAtomModel, this.mvt, this.orbitalViewProperty));
        ElementNameIndicator elementNameIndicator = new ElementNameIndicator(buildAnAtomModel.getAtom(), this.showName, false);
        elementNameIndicator.setOffset(this.mvt.modelToViewX(0.0), this.mvt.modelToViewY(25.5) + elementNameIndicator.getFullBounds().getHeight() / 2.0);
        this.indicatorLayer.addChild(elementNameIndicator);
        StabilityIndicator stabilityIndicator = new StabilityIndicator(buildAnAtomModel.getAtom(), this.showStableUnstable){
            {
                this.setOffset(BuildAnAtomCanvas.this.mvt.modelToViewX(0.0), BuildAnAtomCanvas.this.mvt.modelToViewY(-22.78));
            }
        };
        this.indicatorLayer.addChild(stabilityIndicator);
        ParticleCountLegend particleCountLegend = new ParticleCountLegend(buildAnAtomModel.getAtom());
        particleCountLegend.setOffset(20.0, 10.0);
        this.indicatorLayer.addChild(particleCountLegend);
        final PDimension pDimension = new PDimension(400.0, 100.0);
        int n = 600;
        PDimension pDimension2 = new PDimension(400.0, 226.0);
        HighlightingPeriodicTable highlightingPeriodicTable = new HighlightingPeriodicTable(buildAnAtomModel.getAtom(), BuildAnAtomConstants.CANVAS_BACKGROUND);
        this.elementIndicatorWindow = new MaximizeControlNode(BuildAnAtomStrings.INDICATOR_ELEMENT, pDimension2, (PNode)highlightingPeriodicTable, true);
        highlightingPeriodicTable.setOffset(pDimension2.width / 2.0 - highlightingPeriodicTable.getFullBounds().getWidth() / 2.0, pDimension2.getHeight() / 2.0 - highlightingPeriodicTable.getFullBounds().getHeight() / 2.0);
        this.elementIndicatorWindow.setOffset(n, 12.0);
        highlightingPeriodicTable.translate(0.0, 10.0);
        this.indicatorLayer.addChild(this.elementIndicatorWindow);
        SymbolIndicatorNode symbolIndicatorNode = new SymbolIndicatorNode(buildAnAtomModel.getAtom(), false);
        this.symbolWindow = new MaximizeControlNode(BuildAnAtomStrings.INDICATOR_SYMBOL, pDimension, (PNode)symbolIndicatorNode, true);
        symbolIndicatorNode.setOffset(20.0, pDimension.height / 2.0 - symbolIndicatorNode.getFullBounds().getHeight() / 2.0);
        this.symbolWindow.setOffset(n, 250.0);
        this.indicatorLayer.addChild(this.symbolWindow);
        this.massWindow = new MaximizeControlNode(BuildAnAtomStrings.INDICATOR_MASS_NUMBER, pDimension, (PNode)new MassIndicatorNode(buildAnAtomModel.getAtom(), this.orbitalViewProperty){
            {
                super(atom, property);
                this.setOffset(20.0, pDimension.height / 2.0 - this.getFullBounds().getHeight() / 2.0);
            }
        }, true);
        this.massWindow.setOffset(n, this.symbolWindow.getFullBounds().getMaxY() + 12.0);
        this.indicatorLayer.addChild(this.massWindow);
        ChargeIndicatorNode chargeIndicatorNode = new ChargeIndicatorNode(buildAnAtomModel.getAtom());
        this.chargeWindow = new MaximizeControlNode(BuildAnAtomStrings.INDICATOR_CHARGE, pDimension, (PNode)chargeIndicatorNode, true);
        chargeIndicatorNode.setOffset(20.0, pDimension.height / 2.0 - chargeIndicatorNode.getFullBounds().getHeight() / 2.0);
        this.chargeWindow.setOffset(n, this.massWindow.getFullBounds().getMaxY() + 12.0);
        this.indicatorLayer.addChild(this.chargeWindow);
        PSwing pSwing = BuildAnAtomCanvas.createCheckBox(BuildAnAtomStrings.SHOW_ELEMENT_NAME, this.showName);
        pSwing.setOffset(this.chargeWindow.getFullBounds().getMinX(), this.chargeWindow.getFullBounds().getMaxY() + 5.0);
        this.indicatorLayer.addChild(pSwing);
        PSwing pSwing2 = BuildAnAtomCanvas.createCheckBox(BuildAnAtomStrings.SHOW_NEUTRAL_ION, this.showNeutralIon);
        pSwing2.setOffset(pSwing.getFullBounds().getX(), pSwing.getFullBounds().getMaxY() - 5.0);
        this.indicatorLayer.addChild(pSwing2);
        PSwing pSwing3 = BuildAnAtomCanvas.createCheckBox(BuildAnAtomStrings.SHOW_STABLE_UNSTABLE, this.showStableUnstable);
        pSwing3.setOffset(pSwing2.getFullBounds().getX(), pSwing2.getFullBounds().getMaxY() - 5.0);
        this.indicatorLayer.addChild(pSwing3);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(this, (Component)this, 16, Color.BLACK, new Color(255, 153, 0));
        double d = 100.0;
        resetAllButtonNode.setScale(d / resetAllButtonNode.getFullBoundsReference().width);
        this.indicatorLayer.addChild(resetAllButtonNode);
        double d2 = Collections.max(Arrays.asList(pSwing.getFullBoundsReference().getMaxX(), pSwing2.getFullBoundsReference().getMaxX(), pSwing3.getFullBoundsReference().getMaxX()));
        resetAllButtonNode.setOffset(d2 + (this.chargeWindow.getFullBounds().getMaxX() - d2) / 2.0 - resetAllButtonNode.getFullBoundsReference().width / 2.0, pSwing2.getFullBoundsReference().getCenterY() - resetAllButtonNode.getFullBoundsReference().height / 2.0);
        OrbitalViewControl orbitalViewControl = new OrbitalViewControl(this.orbitalViewProperty);
        orbitalViewControl.setOffset(this.chargeWindow.getFullBounds().getMinX() - orbitalViewControl.getFullBounds().getWidth() - 20.0, this.chargeWindow.getFullBounds().getY() - 12.0);
        this.indicatorLayer.addChild(orbitalViewControl);
        IonIndicatorNode ionIndicatorNode = new IonIndicatorNode(buildAnAtomModel.getAtom(), this.showNeutralIon, 175.0);
        ionIndicatorNode.setOffset(this.elementIndicatorWindow.getFullBounds().getMinX() - ionIndicatorNode.getFullBounds().getWidth() - 10.0, this.elementIndicatorWindow.getFullBounds().getCenterY() - ionIndicatorNode.getFullBounds().getHeight() / 2.0);
        this.indicatorLayer.addChild(ionIndicatorNode);
        this.setFocusable(true);
        this.requestFocus();
        this.resetWindowMaximization();
    }

    private static PSwing createCheckBox(String string, final BooleanProperty booleanProperty) {
        PSwing pSwing = new PSwing(new JCheckBox(string, (Boolean)booleanProperty.get()){
            {
                super(string, bl);
                this.setFont(new PhetFont(16, true));
                this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        booleanProperty.set(this.isSelected());
                    }
                });
                booleanProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setSelected((Boolean)booleanProperty.get());
                    }
                });
            }
        });
        return pSwing;
    }

    private void resetWindowMaximization() {
        this.elementIndicatorWindow.setMaximized(true);
        this.symbolWindow.setMaximized(false);
        this.massWindow.setMaximized(false);
        this.chargeWindow.setMaximized(false);
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
    }

    public void reset() {
        this.model.reset();
        this.resetWindowMaximization();
        this.orbitalViewProperty.reset();
        this.showName.reset();
        this.showNeutralIon.reset();
        this.showStableUnstable.reset();
    }
}

