/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.model;

import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MixIsotopesModel;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Color;
import java.awt.geom.Point2D;

public class NumericalIsotopeQuantityControl {
    private final Point2D centerPosition = new Point2D.Double();
    private final ImmutableAtom isotopeConfig;
    private final MixIsotopesModel model;
    private final Property<Integer> quantityProperty = new Property<Integer>(0);
    private final BooleanProperty partOfModelProperty = new BooleanProperty(true);

    public NumericalIsotopeQuantityControl(MixIsotopesModel mixIsotopesModel, ImmutableAtom immutableAtom, Point2D point2D) {
        this.model = mixIsotopesModel;
        this.isotopeConfig = immutableAtom;
        this.centerPosition.setLocation(point2D);
    }

    public Point2D getCenterPositionRef() {
        return this.centerPosition;
    }

    public ImmutableAtom getIsotopeConfig() {
        return this.isotopeConfig;
    }

    public int getCapacity() {
        return 100;
    }

    public BooleanProperty getPartOfModelProperty() {
        return this.partOfModelProperty;
    }

    protected void removedFromModel() {
        this.partOfModelProperty.set(false);
    }

    public void setIsotopeQuantity(int n) {
        assert (n <= 100);
        int n2 = n - this.model.getIsotopeTestChamber().getIsotopeCount(this.isotopeConfig);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                MovableAtom movableAtom = new MovableAtom(this.isotopeConfig.getNumProtons(), this.isotopeConfig.getNumNeutrons(), 30.0, this.model.getIsotopeTestChamber().generateRandomLocation(), this.model.getClock());
                this.model.getIsotopeTestChamber().addIsotopeToChamber(movableAtom);
                this.model.notifyIsotopeInstanceAdded(movableAtom);
            }
        } else if (n2 < 0) {
            for (int i = 0; i < -n2; ++i) {
                MovableAtom movableAtom = this.model.getIsotopeTestChamber().removeIsotopeMatchingConfig(this.isotopeConfig);
                if (movableAtom == null) continue;
                movableAtom.removedFromModel();
            }
        }
        this.quantityProperty.set(n);
    }

    protected void syncToTestChamber() {
        this.quantityProperty.set(this.model.getIsotopeTestChamber().getIsotopeCount(this.isotopeConfig));
    }

    public Color getBaseColor() {
        return this.model.getColorForIsotope(this.isotopeConfig);
    }

    public void addQuantityPropertyObserver(SimpleObserver simpleObserver) {
        this.quantityProperty.addObserver(simpleObserver);
    }

    public int getQuantity() {
        assert (this.quantityProperty.get().intValue() == this.model.getIsotopeTestChamber().getIsotopeCount(this.getIsotopeConfig()));
        return this.quantityProperty.get();
    }
}

