/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.model;

import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.BuildAnAtomClock;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.model.IConfigurableAtomModel;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.model.MonoIsotopeParticleBucket;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.buildanatom.modules.game.model.SimpleAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.IsotopeTestChamber;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.NumericalIsotopeQuantityControl;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixIsotopesModel
implements IConfigurableAtomModel,
Resettable {
    private static final ImmutableAtom DEFAULT_PROTOTYPE_ISOTOPE_CONFIG = AtomIdentifier.getMostCommonIsotope(1);
    private static final Dimension2D BUCKET_SIZE = new PDimension(1000.0, 400.0);
    private static final Color[] ISOTOPE_COLORS = new Color[]{new Color(180, 82, 205), Color.green, new Color(255, 69, 0), new Color(139, 90, 43)};
    private final BuildAnAtomClock clock;
    private final IsotopeTestChamber testChamber = new IsotopeTestChamber(this);
    private final SimpleAtom prototypeIsotope = new SimpleAtom(0, 0, 0);
    private final Property<List<ImmutableAtom>> possibleIsotopesProperty = new Property(new ArrayList());
    private final List<MonoIsotopeParticleBucket> bucketList = new ArrayList<MonoIsotopeParticleBucket>();
    private final List<NumericalIsotopeQuantityControl> numericalControllerList = new ArrayList<NumericalIsotopeQuantityControl>();
    private final Property<InteractivityMode> interactivityModeProperty = new Property<InteractivityMode>(InteractivityMode.BUCKETS_AND_LARGE_ATOMS);
    private final Map<Integer, State> mapIsotopeConfigToUserMixState = new HashMap<Integer, State>();
    private final BooleanProperty showingNaturesMixProperty = new BooleanProperty(false);
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final SimpleObserver interactivityModeObserver = new SimpleObserver(){

        public void update() {
            assert (!((Boolean)MixIsotopesModel.this.showingNaturesMixProperty.get()).booleanValue());
            if (MixIsotopesModel.this.mapIsotopeConfigToUserMixState.containsKey(MixIsotopesModel.this.prototypeIsotope.getNumProtons())) {
                MixIsotopesModel.this.mapIsotopeConfigToUserMixState.remove(MixIsotopesModel.this.prototypeIsotope.getNumProtons());
            }
            MixIsotopesModel.this.removeAllIsotopesFromTestChamberAndModel();
            MixIsotopesModel.this.addIsotopeControllers();
        }
    };
    protected final SphericalParticle.Adapter isotopeGrabbedListener = new SphericalParticle.Adapter(){

        public void grabbedByUser(SphericalParticle sphericalParticle) {
            assert (sphericalParticle instanceof MovableAtom);
            MovableAtom movableAtom = (MovableAtom)sphericalParticle;
            if (MixIsotopesModel.this.testChamber.isIsotopeContained(movableAtom)) {
                MixIsotopesModel.this.testChamber.removeIsotopeFromChamber(movableAtom);
            }
            movableAtom.addListener(MixIsotopesModel.this.isotopeDroppedListener);
        }
    };
    protected final SphericalParticle.Adapter isotopeDroppedListener = new SphericalParticle.Adapter(){

        public void droppedByUser(SphericalParticle sphericalParticle) {
            assert (sphericalParticle instanceof MovableAtom);
            MovableAtom movableAtom = (MovableAtom)sphericalParticle;
            if (MixIsotopesModel.this.testChamber.isIsotopePositionedOverChamber(movableAtom)) {
                MixIsotopesModel.this.testChamber.addIsotopeToChamber(movableAtom);
                MixIsotopesModel.this.testChamber.adjustForOverlap();
            } else {
                MonoIsotopeParticleBucket monoIsotopeParticleBucket = MixIsotopesModel.this.getBucketForIsotope(movableAtom.getAtomConfiguration());
                assert (monoIsotopeParticleBucket != null);
                monoIsotopeParticleBucket.addIsotopeInstanceNearestOpen(movableAtom, false);
            }
            sphericalParticle.removeListener(MixIsotopesModel.this.isotopeDroppedListener);
        }
    };

    public MixIsotopesModel(BuildAnAtomClock buildAnAtomClock) {
        this.clock = buildAnAtomClock;
        this.interactivityModeProperty.addObserver(this.interactivityModeObserver);
        this.showingNaturesMixProperty.addObserver(new SimpleObserver(){

            public void update() {
                if (((Boolean)MixIsotopesModel.this.showingNaturesMixProperty.get()).booleanValue()) {
                    State state = MixIsotopesModel.this.getState();
                    state.setShowingNaturesMix(false);
                    MixIsotopesModel.this.mapIsotopeConfigToUserMixState.put(MixIsotopesModel.this.prototypeIsotope.getNumProtons(), state);
                    MixIsotopesModel.this.showNaturesMix();
                } else if (MixIsotopesModel.this.mapIsotopeConfigToUserMixState.containsKey(MixIsotopesModel.this.prototypeIsotope.getNumProtons())) {
                    MixIsotopesModel.this.setState((State)MixIsotopesModel.this.mapIsotopeConfigToUserMixState.get(MixIsotopesModel.this.prototypeIsotope.getNumProtons()));
                } else {
                    MixIsotopesModel.this.setUpInitialUsersMix();
                }
            }
        }, false);
    }

    protected MovableAtom createAndAddIsotope(ImmutableAtom immutableAtom, boolean bl) {
        MovableAtom movableAtom;
        assert (immutableAtom.getNumProtons() == this.prototypeIsotope.getNumProtons());
        assert (immutableAtom.getNumProtons() == immutableAtom.getNumElectrons());
        if (this.interactivityModeProperty.get() == InteractivityMode.BUCKETS_AND_LARGE_ATOMS) {
            movableAtom = new MovableAtom(immutableAtom.getNumProtons(), immutableAtom.getNumNeutrons(), 83.0, new Point2D.Double(), this.getClock());
            movableAtom.setMotionVelocity(2500.0);
            movableAtom.addListener(this.isotopeGrabbedListener);
            this.getBucketForIsotope(immutableAtom).addIsotopeInstanceFirstOpen(movableAtom, bl);
        } else {
            Point2D point2D = this.testChamber.generateRandomLocation();
            movableAtom = new MovableAtom(immutableAtom.getNumProtons(), immutableAtom.getNumNeutrons(), 30.0, point2D, this.getClock());
            this.testChamber.addIsotopeToChamber(movableAtom);
        }
        this.notifyIsotopeInstanceAdded(movableAtom);
        return movableAtom;
    }

    private void setUpInitialUsersMix() {
        this.removeAllIsotopesFromTestChamberAndModel();
        this.showingNaturesMixProperty.set(false);
        this.interactivityModeProperty.set(InteractivityMode.BUCKETS_AND_LARGE_ATOMS);
        this.mapIsotopeConfigToUserMixState.remove(this.prototypeIsotope.getNumProtons());
        this.addIsotopeControllers();
    }

    public BuildAnAtomClock getClock() {
        return this.clock;
    }

    @Override
    public IDynamicAtom getAtom() {
        return this.prototypeIsotope;
    }

    private State getState() {
        return new State(this);
    }

    private void setState(State state) {
        this.removeAllIsotopesFromTestChamberAndModel();
        this.prototypeIsotope.setConfiguration(state.getElementConfiguration());
        this.updatePossibleIsotopesList();
        this.interactivityModeProperty.removeObserver(this.interactivityModeObserver);
        this.interactivityModeProperty.set(state.getInteractivityMode());
        this.interactivityModeProperty.addObserver(this.interactivityModeObserver, false);
        assert (state.isShowingNaturesMix() == ((Boolean)this.showingNaturesMixProperty.get()).booleanValue());
        this.showingNaturesMixProperty.set(state.isShowingNaturesMix());
        this.testChamber.setState(state.getIsotopeTestChamberState());
        for (MovableAtom object : this.testChamber.getContainedIsotopes()) {
            object.addListener(this.isotopeGrabbedListener);
            object.addedToModel();
            this.notifyIsotopeInstanceAdded(object);
        }
        this.addIsotopeControllers();
        if (this.interactivityModeProperty.get() == InteractivityMode.BUCKETS_AND_LARGE_ATOMS) {
            for (ImmutableAtom immutableAtom : this.possibleIsotopesProperty.get()) {
                int n = this.testChamber.getIsotopeCount(immutableAtom);
                MonoIsotopeParticleBucket monoIsotopeParticleBucket = this.getBucketForIsotope(immutableAtom);
                for (int i = 0; i < n; ++i) {
                    MovableAtom movableAtom = monoIsotopeParticleBucket.removeArbitraryIsotope();
                    movableAtom.removeListener(this.isotopeGrabbedListener);
                    movableAtom.removedFromModel();
                }
            }
        } else {
            assert (this.interactivityModeProperty.get() == InteractivityMode.SLIDERS_AND_SMALL_ATOMS);
            for (ImmutableAtom immutableAtom : this.possibleIsotopesProperty.get()) {
                NumericalIsotopeQuantityControl numericalIsotopeQuantityControl = this.getNumericalControllerForIsotope(immutableAtom);
                numericalIsotopeQuantityControl.setIsotopeQuantity(this.testChamber.getIsotopeCount(immutableAtom));
            }
        }
    }

    @Override
    public void setAtomConfiguration(IAtom iAtom) {
        if (((Boolean)this.showingNaturesMixProperty.get()).booleanValue()) {
            this.removeAllIsotopesFromTestChamberAndModel();
            this.prototypeIsotope.setConfiguration(iAtom);
            this.updatePossibleIsotopesList();
            this.showNaturesMix();
        } else {
            if (!iAtom.equals(this.prototypeIsotope.toImmutableAtom())) {
                this.mapIsotopeConfigToUserMixState.put(this.prototypeIsotope.getNumProtons(), this.getState());
            }
            if (this.mapIsotopeConfigToUserMixState.containsKey(iAtom.getNumProtons())) {
                this.setState(this.mapIsotopeConfigToUserMixState.get(iAtom.getNumProtons()));
            } else {
                this.removeAllIsotopesFromTestChamberAndModel();
                this.prototypeIsotope.setConfiguration(iAtom);
                this.updatePossibleIsotopesList();
                this.setUpInitialUsersMix();
            }
        }
    }

    public void updatePossibleIsotopesList() {
        ArrayList<ImmutableAtom> arrayList = AtomIdentifier.getStableIsotopesOfElement(this.prototypeIsotope.getNumProtons());
        Collections.sort(arrayList, new Comparator<IAtom>(){

            @Override
            public int compare(IAtom iAtom, IAtom iAtom2) {
                return new Double(iAtom.getAtomicMass()).compareTo(iAtom2.getAtomicMass());
            }
        });
        this.possibleIsotopesProperty.set(arrayList);
    }

    private void removeBuckets() {
        for (MonoIsotopeParticleBucket object2 : this.bucketList) {
            for (MovableAtom movableAtom : object2.getContainedIsotopes()) {
                object2.removeParticle(movableAtom);
                movableAtom.removedFromModel();
                movableAtom.removeListener(this.isotopeGrabbedListener);
            }
        }
        ArrayList<MonoIsotopeParticleBucket> arrayList = new ArrayList<MonoIsotopeParticleBucket>(this.bucketList);
        this.bucketList.clear();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MonoIsotopeParticleBucket monoIsotopeParticleBucket = (MonoIsotopeParticleBucket)iterator.next();
            this.notifyBucketRemoved(monoIsotopeParticleBucket);
        }
    }

    private void addIsotopeControllers() {
        double d;
        double d2;
        this.removeBuckets();
        this.removeNumericalControllers();
        boolean bl = this.interactivityModeProperty.get() == InteractivityMode.BUCKETS_AND_LARGE_ATOMS || (Boolean)this.showingNaturesMixProperty.get() != false;
        double d3 = this.testChamber.getTestChamberRect().getMinY() - 400.0;
        if (this.possibleIsotopesProperty.get().size() < 4) {
            d2 = this.testChamber.getTestChamberRect().getWidth() / (double)this.possibleIsotopesProperty.get().size();
            d = this.testChamber.getTestChamberRect().getMinX() + d2 / 2.0;
        } else {
            d2 = this.testChamber.getTestChamberRect().getWidth() * 1.2 / (double)this.possibleIsotopesProperty.get().size();
            d = this.testChamber.getTestChamberRect().getMinX() + d2 / 2.0;
        }
        for (int i = 0; i < this.possibleIsotopesProperty.get().size(); ++i) {
            Object object;
            ImmutableAtom immutableAtom = this.possibleIsotopesProperty.get().get(i);
            if (bl) {
                object = AtomIdentifier.getName(immutableAtom) + "-" + immutableAtom.getMassNumber();
                MonoIsotopeParticleBucket monoIsotopeParticleBucket = new MonoIsotopeParticleBucket((Point2D)new Point2D.Double(d + d2 * (double)i, d3), BUCKET_SIZE, this.getColorForIsotope(immutableAtom), (String)object, 83.0, immutableAtom.getNumProtons(), immutableAtom.getNumNeutrons());
                this.addBucket(monoIsotopeParticleBucket);
                if (((Boolean)this.showingNaturesMixProperty.get()).booleanValue()) continue;
                for (int j = 0; j < 10; ++j) {
                    this.createAndAddIsotope(immutableAtom, true);
                }
                continue;
            }
            object = new NumericalIsotopeQuantityControl(this, immutableAtom, new Point2D.Double(d + d2 * (double)i, d3));
            ((NumericalIsotopeQuantityControl)object).setIsotopeQuantity(this.testChamber.getIsotopeCount(immutableAtom));
            this.numericalControllerList.add((NumericalIsotopeQuantityControl)object);
            this.notifyNumericalControllerAdded((NumericalIsotopeQuantityControl)object);
        }
    }

    private void addBucket(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
        this.bucketList.add(monoIsotopeParticleBucket);
        this.notifyBucketAdded(monoIsotopeParticleBucket);
    }

    private void removeNumericalControllers() {
        ArrayList<NumericalIsotopeQuantityControl> arrayList = new ArrayList<NumericalIsotopeQuantityControl>(this.numericalControllerList);
        this.numericalControllerList.clear();
        for (NumericalIsotopeQuantityControl numericalIsotopeQuantityControl : arrayList) {
            numericalIsotopeQuantityControl.removedFromModel();
        }
    }

    private MonoIsotopeParticleBucket getBucketForIsotope(ImmutableAtom immutableAtom) {
        MonoIsotopeParticleBucket monoIsotopeParticleBucket = null;
        for (MonoIsotopeParticleBucket monoIsotopeParticleBucket2 : this.bucketList) {
            if (!monoIsotopeParticleBucket2.isIsotopeAllowed(immutableAtom)) continue;
            monoIsotopeParticleBucket = monoIsotopeParticleBucket2;
            break;
        }
        return monoIsotopeParticleBucket;
    }

    private NumericalIsotopeQuantityControl getNumericalControllerForIsotope(ImmutableAtom immutableAtom) {
        NumericalIsotopeQuantityControl numericalIsotopeQuantityControl = null;
        for (NumericalIsotopeQuantityControl numericalIsotopeQuantityControl2 : this.numericalControllerList) {
            if (!numericalIsotopeQuantityControl2.getIsotopeConfig().equals(immutableAtom)) continue;
            numericalIsotopeQuantityControl = numericalIsotopeQuantityControl2;
            break;
        }
        return numericalIsotopeQuantityControl;
    }

    public IsotopeTestChamber getIsotopeTestChamber() {
        return this.testChamber;
    }

    public Property<List<ImmutableAtom>> getPossibleIsotopesProperty() {
        return this.possibleIsotopesProperty;
    }

    public Property<InteractivityMode> getInteractivityModeProperty() {
        return this.interactivityModeProperty;
    }

    public BooleanProperty getShowingNaturesMixProperty() {
        return this.showingNaturesMixProperty;
    }

    public Color getColorForIsotope(ImmutableAtom immutableAtom) {
        int n = this.possibleIsotopesProperty.get().indexOf(immutableAtom);
        return n >= 0 ? ISOTOPE_COLORS[this.possibleIsotopesProperty.get().indexOf(immutableAtom)] : Color.WHITE;
    }

    @Override
    public void reset() {
        this.showingNaturesMixProperty.reset();
        this.interactivityModeProperty.reset();
        this.mapIsotopeConfigToUserMixState.remove(DEFAULT_PROTOTYPE_ISOTOPE_CONFIG.getNumProtons());
        this.setAtomConfiguration(DEFAULT_PROTOTYPE_ISOTOPE_CONFIG);
        this.mapIsotopeConfigToUserMixState.clear();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    protected void notifyIsotopeInstanceAdded(MovableAtom movableAtom) {
        for (Listener listener : this.listeners) {
            listener.isotopeInstanceAdded(movableAtom);
        }
    }

    private void notifyBucketAdded(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
        for (Listener listener : this.listeners) {
            listener.isotopeBucketAdded(monoIsotopeParticleBucket);
        }
    }

    private void notifyBucketRemoved(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
        for (Listener listener : this.listeners) {
            listener.isotopeBucketRemoved(monoIsotopeParticleBucket);
        }
    }

    private void notifyNumericalControllerAdded(NumericalIsotopeQuantityControl numericalIsotopeQuantityControl) {
        for (Listener listener : this.listeners) {
            listener.isotopeNumericalControllerAdded(numericalIsotopeQuantityControl);
        }
    }

    private void showNaturesMix() {
        assert (((Boolean)this.showingNaturesMixProperty.get()).booleanValue());
        this.removeAllIsotopesFromTestChamberAndModel();
        ArrayList arrayList = new ArrayList(this.getPossibleIsotopesProperty().get());
        Collections.sort(arrayList, new Comparator<IAtom>(){

            @Override
            public int compare(IAtom iAtom, IAtom iAtom2) {
                return new Double(AtomIdentifier.getNaturalAbundance(iAtom2)).compareTo(AtomIdentifier.getNaturalAbundance(iAtom));
            }
        });
        for (ImmutableAtom immutableAtom : arrayList) {
            int n = (int)Math.round(1000.0 * AtomIdentifier.getNaturalAbundance(immutableAtom));
            if (n == 0) {
                n = 1;
            }
            ArrayList<MovableAtom> arrayList2 = new ArrayList<MovableAtom>();
            for (int i = 0; i < n; ++i) {
                MovableAtom movableAtom = new MovableAtom(immutableAtom.getNumProtons(), immutableAtom.getNumNeutrons(), 30.0, this.testChamber.generateRandomLocation(), this.clock);
                arrayList2.add(movableAtom);
                this.notifyIsotopeInstanceAdded(movableAtom);
            }
            this.testChamber.bulkAddIsotopesToChamber(arrayList2);
        }
        this.addIsotopeControllers();
    }

    private void removeAllIsotopesFromTestChamberAndModel() {
        this.testChamber.removeAllIsotopes(true);
    }

    public void clearTestChamber() {
        for (MovableAtom object : new ArrayList<MovableAtom>(this.testChamber.getContainedIsotopes())) {
            this.testChamber.removeIsotopeFromChamber(object);
            if (this.interactivityModeProperty.get() == InteractivityMode.BUCKETS_AND_LARGE_ATOMS) {
                this.getBucketForIsotope(object.getAtomConfiguration()).addIsotopeInstanceFirstOpen(object, true);
                continue;
            }
            object.removeListener(this.isotopeGrabbedListener);
            object.removedFromModel();
        }
        for (NumericalIsotopeQuantityControl numericalIsotopeQuantityControl : this.numericalControllerList) {
            numericalIsotopeQuantityControl.syncToTestChamber();
        }
    }

    public static class Adapter
    implements Listener {
        public void isotopeInstanceAdded(MovableAtom movableAtom) {
        }

        public void isotopeBucketAdded(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
        }

        public void isotopeBucketRemoved(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
        }

        public void isotopeNumericalControllerAdded(NumericalIsotopeQuantityControl numericalIsotopeQuantityControl) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InteractivityMode
    extends Enum<InteractivityMode> {
        public static final /* enum */ InteractivityMode BUCKETS_AND_LARGE_ATOMS = new InteractivityMode();
        public static final /* enum */ InteractivityMode SLIDERS_AND_SMALL_ATOMS = new InteractivityMode();
        private static final /* synthetic */ InteractivityMode[] $VALUES;

        public static InteractivityMode[] values() {
            return (InteractivityMode[])$VALUES.clone();
        }

        static {
            $VALUES = new InteractivityMode[]{BUCKETS_AND_LARGE_ATOMS, SLIDERS_AND_SMALL_ATOMS};
        }
    }

    public static interface Listener {
        public void isotopeInstanceAdded(MovableAtom var1);

        public void isotopeBucketAdded(MonoIsotopeParticleBucket var1);

        public void isotopeBucketRemoved(MonoIsotopeParticleBucket var1);

        public void isotopeNumericalControllerAdded(NumericalIsotopeQuantityControl var1);
    }

    private static class State {
        private final ImmutableAtom elementConfig;
        private final IsotopeTestChamber.State isotopeTestChamberState;
        private final InteractivityMode interactivityMode;
        private boolean showingNaturesMix;

        public State(MixIsotopesModel mixIsotopesModel) {
            this.elementConfig = mixIsotopesModel.getAtom().toImmutableAtom();
            this.isotopeTestChamberState = mixIsotopesModel.getIsotopeTestChamber().getState();
            this.interactivityMode = mixIsotopesModel.getInteractivityModeProperty().get();
            this.showingNaturesMix = (Boolean)mixIsotopesModel.showingNaturesMixProperty.get();
        }

        public IAtom getElementConfiguration() {
            return this.elementConfig;
        }

        public IsotopeTestChamber.State getIsotopeTestChamberState() {
            return this.isotopeTestChamberState;
        }

        public InteractivityMode getInteractivityMode() {
            return this.interactivityMode;
        }

        public boolean isShowingNaturesMix() {
            return this.showingNaturesMix;
        }

        public void setShowingNaturesMix(boolean bl) {
            this.showingNaturesMix = bl;
        }
    }
}

