/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.interactiveisotope.view;

import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.NumericalIsotopeQuantityControl;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.LabeledIsotopeNode;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.MixIsotopesCanvas;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.DefaultLayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IsotopeSliderNode
extends PNode {
    private static final Dimension2D SIZE = new PDimension(120.0, 75.0);

    public IsotopeSliderNode(final NumericalIsotopeQuantityControl numericalIsotopeQuantityControl, ModelViewTransform modelViewTransform) {
        PNode pNode = new PNode();
        pNode.setOffset(modelViewTransform.modelToView(numericalIsotopeQuantityControl.getCenterPositionRef()));
        this.addChild(pNode);
        String string = numericalIsotopeQuantityControl.getIsotopeConfig().getName() + "-" + numericalIsotopeQuantityControl.getIsotopeConfig().getMassNumber();
        final LinearValueControl linearValueControl = new LinearValueControl(0.0, numericalIsotopeQuantityControl.getCapacity(), string, "###", null, new DefaultLayoutStrategy(0)){
            {
                super(d, d2, string, string2, string3, iLayoutStrategy);
                this.setUpDownArrowDelta(1.0);
                this.setMajorTicksVisible(false);
                this.setMinorTicksVisible(false);
                this.setTextFieldEditable(true);
                this.setFont(new PhetFont(0, 14));
                this.setSliderWidth((int)SIZE.getWidth());
                this.setValue(0.0);
                this.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        numericalIsotopeQuantityControl.setIsotopeQuantity((int)Math.round(this.getValue()));
                    }
                });
                SwingUtils.setBackgroundDeep(this, MixIsotopesCanvas.BACKGROUND_COLOR);
                this.getTextField().setBackground(Color.WHITE);
                LabeledIsotopeNode labeledIsotopeNode = new LabeledIsotopeNode(ModelViewTransform.createIdentity(), new MovableAtom(numericalIsotopeQuantityControl.getIsotopeConfig().getNumProtons(), numericalIsotopeQuantityControl.getIsotopeConfig().getNumNeutrons(), 10.0, new Point2D.Double(0.0, 0.0)), numericalIsotopeQuantityControl.getBaseColor());
                this.setValueLabelIcon(new ImageIcon(labeledIsotopeNode.toImage()));
            }
        };
        PSwing pSwing = new PSwing(linearValueControl){
            {
                this.centerFullBoundsOnPoint(0.0, 0.0);
            }
        };
        pNode.addChild(pSwing);
        numericalIsotopeQuantityControl.addQuantityPropertyObserver(new SimpleObserver(){

            public void update() {
                if (numericalIsotopeQuantityControl.getQuantity() != (int)linearValueControl.getValue()) {
                    linearValueControl.setValue(numericalIsotopeQuantityControl.getQuantity());
                }
            }
        });
    }
}

