/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.BuildAnAtomModel;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.Proton;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.buildanatom.modules.game.view.SchematicAtomNode;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveSchematicAtomNode
extends SchematicAtomNode {
    private final BuildAnAtomModel model;

    public InteractiveSchematicAtomNode(BuildAnAtomModel buildAnAtomModel, ModelViewTransform modelViewTransform, Property<OrbitalView> property) {
        super(buildAnAtomModel.getAtom(), modelViewTransform, property);
        this.model = buildAnAtomModel;
        this.electronShellLayer.addChild(new CenterMarkerNode(buildAnAtomModel, modelViewTransform));
        BucketView bucketView = new BucketView(buildAnAtomModel.getElectronBucket(), modelViewTransform);
        this.electronShellLayer.addChild(bucketView.getHoleNode());
        this.frontLayer.addChild(bucketView.getFrontNode());
        for (SphericalParticle object2 : buildAnAtomModel.getElectronBucket().getParticleList()) {
            this.addElectronNode((Electron)object2);
        }
        BucketView bucketView2 = new BucketView(buildAnAtomModel.getProtonBucket(), modelViewTransform);
        this.electronShellLayer.addChild(bucketView2.getHoleNode());
        this.frontLayer.addChild(bucketView2.getFrontNode());
        for (SphericalParticle sphericalParticle : buildAnAtomModel.getProtonBucket().getParticleList()) {
            this.addProtonNode((Proton)sphericalParticle);
        }
        BucketView bucketView3 = new BucketView(buildAnAtomModel.getNeutronBucket(), modelViewTransform);
        this.electronShellLayer.addChild(bucketView3.getHoleNode());
        this.frontLayer.addChild(bucketView3.getFrontNode());
        for (SphericalParticle sphericalParticle : buildAnAtomModel.getNeutronBucket().getParticleList()) {
            this.addNeutronNode((Neutron)sphericalParticle);
        }
    }

    public ImmutableAtom getAtomValue() {
        return this.model.getAtom().toImmutableAtom();
    }

    public void setAtomValue(ImmutableAtom immutableAtom) {
        this.model.setState(immutableAtom, false);
    }

    private static class CenterMarkerNode
    extends PNode {
        public CenterMarkerNode(final BuildAnAtomModel buildAnAtomModel, ModelViewTransform modelViewTransform) {
            this.setPickable(false);
            this.setChildrenPickable(false);
            buildAnAtomModel.getAtom().addAtomListener(new AtomListener.Adapter(){

                public void configurationChanged() {
                    CenterMarkerNode.this.setVisible(buildAnAtomModel.getAtom().getMassNumber() == 0);
                }
            });
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            double d = 5.0;
            doubleGeneralPath.moveTo(buildAnAtomModel.getAtom().getPosition().getX() - d / 2.0, buildAnAtomModel.getAtom().getPosition().getY() - d / 2.0);
            doubleGeneralPath.lineTo(buildAnAtomModel.getAtom().getPosition().getX() + d / 2.0, buildAnAtomModel.getAtom().getPosition().getY() + d / 2.0);
            doubleGeneralPath.moveTo(buildAnAtomModel.getAtom().getPosition().getX() - d / 2.0, buildAnAtomModel.getAtom().getPosition().getY() + d / 2.0);
            doubleGeneralPath.lineTo(buildAnAtomModel.getAtom().getPosition().getX() + d / 2.0, buildAnAtomModel.getAtom().getPosition().getY() - d / 2.0);
            Shape shape = modelViewTransform.modelToView(doubleGeneralPath.getGeneralPath());
            PhetPPath phetPPath = new PhetPPath(shape, (Stroke)new BasicStroke(4.0f), (Paint)new Color(255, 0, 0, 75));
            this.addChild(phetPPath);
        }
    }
}

