/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.StateView;
import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.games.GameOverNode;
import java.text.DecimalFormat;

public class GameOverStateView
extends StateView {
    private final GameOverNode gameOverNode;
    private final GameAudioPlayer gameAudioPlayer;

    public GameOverStateView(BuildAnAtomGameCanvas buildAnAtomGameCanvas, final BuildAnAtomGameModel buildAnAtomGameModel) {
        super(buildAnAtomGameModel, buildAnAtomGameModel.getGameOverState(), buildAnAtomGameCanvas);
        this.gameAudioPlayer = new GameAudioPlayer(buildAnAtomGameModel.isSoundEnabled());
        this.gameAudioPlayer.init();
        this.gameOverNode = new GameOverNode(buildAnAtomGameModel.getLevel(), buildAnAtomGameModel.getScore(), buildAnAtomGameModel.getMaximumPossibleScore(), new DecimalFormat("0.#"), buildAnAtomGameModel.getTime(), buildAnAtomGameModel.getBestTime(buildAnAtomGameModel.getLevel()), buildAnAtomGameModel.isNewBestTime(), buildAnAtomGameModel.isTimerEnabled());
        this.gameOverNode.setScale(1.5);
        this.gameOverNode.addGameOverListener(new GameOverNode.GameOverListener(){

            public void newGamePressed() {
                buildAnAtomGameModel.newGame();
            }
        });
    }

    public void init() {
        this.gameOverNode.setOffset(BuildAnAtomDefaults.STAGE_SIZE.width / 2.0 - this.gameOverNode.getFullBoundsReference().width / 2.0, BuildAnAtomDefaults.STAGE_SIZE.height / 2.0 - this.gameOverNode.getFullBoundsReference().height / 2.0);
        this.addChild(this.gameOverNode);
        if (this.getModel().getScore() == 0) {
            this.gameAudioPlayer.gameOverZeroScore();
        } else if (this.getModel().getScore() == this.getModel().getMaximumPossibleScore()) {
            this.gameAudioPlayer.gameOverPerfectScore();
        } else {
            this.gameAudioPlayer.gameOverImperfectScore();
        }
    }

    public void teardown() {
        this.removeChild(this.gameOverNode);
    }
}

