/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.model;

import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import java.util.HashSet;

public class SimpleAtom
implements IDynamicAtom {
    private int numProtons = 0;
    private int numNeutrons = 0;
    private int numElectrons = 0;
    private final HashSet<AtomListener> listeners = new HashSet();

    public SimpleAtom() {
    }

    public SimpleAtom(int n, int n2, int n3) {
        this.numProtons = n;
        this.numNeutrons = n2;
        this.numElectrons = n3;
    }

    public static String getSymbol(int n) {
        return AtomIdentifier.getSymbol(n);
    }

    public int getNumNeutrons() {
        return this.numNeutrons;
    }

    public int getNumElectrons() {
        return this.numElectrons;
    }

    public int getNumProtons() {
        return this.numProtons;
    }

    public void addAtomListener(final VoidFunction0 voidFunction0) {
        this.addAtomListener(new AtomListener(){

            public void configurationChanged() {
                voidFunction0.apply();
            }

            public void postitionChanged() {
            }
        });
    }

    public void setNumProtons(int n) {
        if (this.numProtons != n) {
            this.numProtons = n;
            this.notifyConfigurationChanged();
        }
    }

    public void setConfiguration(IAtom iAtom) {
        if (this.numProtons != iAtom.getNumProtons() || this.numNeutrons != iAtom.getNumNeutrons() || this.numElectrons != iAtom.getNumElectrons()) {
            this.numProtons = iAtom.getNumProtons();
            this.numNeutrons = iAtom.getNumNeutrons();
            this.numElectrons = iAtom.getNumElectrons();
            this.notifyConfigurationChanged();
        }
    }

    public int getCharge() {
        return this.getNumProtons() - this.getNumElectrons();
    }

    public String getFormattedCharge() {
        if (this.getCharge() <= 0) {
            return "" + this.getCharge();
        }
        return "+" + this.getCharge();
    }

    public String getSymbol() {
        return SimpleAtom.getSymbol(this.getNumProtons());
    }

    public String getName() {
        return AtomIdentifier.getName(this);
    }

    public boolean isStable() {
        return AtomIdentifier.isStable(this);
    }

    public void addAtomListener(AtomListener atomListener) {
        this.listeners.add(atomListener);
    }

    public int getMassNumber() {
        return this.getNumProtons() + this.getNumNeutrons();
    }

    public ImmutableAtom toImmutableAtom() {
        return new ImmutableAtom(this.getNumProtons(), this.getNumNeutrons(), this.getNumElectrons());
    }

    public double getAtomicMass() {
        return AtomIdentifier.getAtomicMass(this);
    }

    public double getNaturalAbundance() {
        return AtomIdentifier.getNaturalAbundance(this);
    }

    private void notifyConfigurationChanged() {
        for (AtomListener atomListener : this.listeners) {
            atomListener.configurationChanged();
        }
    }
}

