/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.model;

import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.Problem;
import edu.colorado.phet.buildanatom.modules.game.model.ProblemSet;
import edu.colorado.phet.buildanatom.modules.game.model.State;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.GameOverStateView;
import edu.colorado.phet.buildanatom.modules.game.view.GameSettingsStateView;
import edu.colorado.phet.buildanatom.modules.game.view.StateView;
import edu.colorado.phet.common.games.GameSettings;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAnAtomGameModel {
    private final ArrayList<GameModelListener> listeners = new ArrayList();
    private final State gameSettingsState = new State(this){

        public StateView createView(BuildAnAtomGameCanvas buildAnAtomGameCanvas) {
            return new GameSettingsStateView(buildAnAtomGameCanvas, BuildAnAtomGameModel.this);
        }
    };
    private final State gameOverState = new State(this){

        public StateView createView(BuildAnAtomGameCanvas buildAnAtomGameCanvas) {
            return new GameOverStateView(buildAnAtomGameCanvas, BuildAnAtomGameModel.this);
        }

        public void init() {
            BuildAnAtomGameModel.this.stopGame();
        }
    };
    private final State nullState;
    private State currentState = this.nullState = new State(this){

        public StateView createView(BuildAnAtomGameCanvas buildAnAtomGameCanvas) {
            throw new RuntimeException("Not implemented.");
        }
    };
    private final Property<Integer> scoreProperty = new Property<Integer>(0);
    private final GameSettings gameSettings = new GameSettings(new IntegerRange(1, 4, 1), true, true);
    private final HashMap<Integer, ArrayList<ImmutableAtom>> levelPools = new HashMap<Integer, ArrayList<ImmutableAtom>>(){
        {
            this.put(1, new ArrayList<ImmutableAtom>(){
                {
                    this.add(new ImmutableAtom(1, 0, 0));
                    this.add(new ImmutableAtom(1, 0, 1));
                    this.add(new ImmutableAtom(1, 0, 2));
                    this.add(new ImmutableAtom(1, 1, 0));
                    this.add(new ImmutableAtom(1, 1, 1));
                    this.add(new ImmutableAtom(1, 1, 2));
                    this.add(new ImmutableAtom(2, 1, 2));
                    this.add(new ImmutableAtom(2, 2, 2));
                    this.add(new ImmutableAtom(3, 3, 2));
                    this.add(new ImmutableAtom(3, 3, 3));
                    this.add(new ImmutableAtom(3, 4, 2));
                    this.add(new ImmutableAtom(3, 4, 3));
                    this.add(new ImmutableAtom(4, 5, 4));
                    this.add(new ImmutableAtom(5, 5, 5));
                    this.add(new ImmutableAtom(5, 6, 5));
                    this.add(new ImmutableAtom(6, 6, 6));
                    this.add(new ImmutableAtom(6, 7, 6));
                    this.add(new ImmutableAtom(7, 7, 7));
                    this.add(new ImmutableAtom(7, 7, 10));
                    this.add(new ImmutableAtom(7, 8, 7));
                    this.add(new ImmutableAtom(7, 8, 10));
                    this.add(new ImmutableAtom(8, 8, 8));
                    this.add(new ImmutableAtom(8, 8, 10));
                    this.add(new ImmutableAtom(8, 9, 8));
                    this.add(new ImmutableAtom(8, 9, 10));
                    this.add(new ImmutableAtom(8, 10, 8));
                    this.add(new ImmutableAtom(8, 10, 10));
                    this.add(new ImmutableAtom(9, 10, 9));
                    this.add(new ImmutableAtom(9, 10, 10));
                    this.add(new ImmutableAtom(10, 10, 10));
                    this.add(new ImmutableAtom(10, 11, 10));
                    this.add(new ImmutableAtom(10, 12, 10));
                }
            });
            this.put(2, new ArrayList<ImmutableAtom>(){
                {
                    this.add(new ImmutableAtom(1, 0, 0));
                    this.add(new ImmutableAtom(1, 0, 1));
                    this.add(new ImmutableAtom(1, 0, 2));
                    this.add(new ImmutableAtom(1, 1, 0));
                    this.add(new ImmutableAtom(1, 1, 1));
                    this.add(new ImmutableAtom(1, 1, 2));
                    this.add(new ImmutableAtom(2, 1, 2));
                    this.add(new ImmutableAtom(2, 2, 2));
                    this.add(new ImmutableAtom(3, 3, 2));
                    this.add(new ImmutableAtom(3, 3, 3));
                    this.add(new ImmutableAtom(3, 4, 2));
                    this.add(new ImmutableAtom(3, 4, 3));
                    this.add(new ImmutableAtom(4, 5, 4));
                    this.add(new ImmutableAtom(5, 5, 5));
                    this.add(new ImmutableAtom(5, 6, 5));
                    this.add(new ImmutableAtom(6, 6, 6));
                    this.add(new ImmutableAtom(6, 7, 6));
                    this.add(new ImmutableAtom(7, 7, 7));
                    this.add(new ImmutableAtom(7, 7, 10));
                    this.add(new ImmutableAtom(7, 8, 7));
                    this.add(new ImmutableAtom(7, 8, 10));
                    this.add(new ImmutableAtom(8, 8, 8));
                    this.add(new ImmutableAtom(8, 8, 10));
                    this.add(new ImmutableAtom(8, 9, 8));
                    this.add(new ImmutableAtom(8, 9, 10));
                    this.add(new ImmutableAtom(8, 10, 8));
                    this.add(new ImmutableAtom(8, 10, 10));
                    this.add(new ImmutableAtom(9, 10, 9));
                    this.add(new ImmutableAtom(9, 10, 10));
                    this.add(new ImmutableAtom(10, 10, 10));
                    this.add(new ImmutableAtom(10, 11, 10));
                    this.add(new ImmutableAtom(10, 12, 10));
                }
            });
            this.put(3, new ArrayList<ImmutableAtom>(){
                {
                    this.add(new ImmutableAtom(1, 0, 0));
                    this.add(new ImmutableAtom(1, 0, 1));
                    this.add(new ImmutableAtom(1, 0, 2));
                    this.add(new ImmutableAtom(1, 1, 0));
                    this.add(new ImmutableAtom(1, 1, 1));
                    this.add(new ImmutableAtom(1, 1, 2));
                    this.add(new ImmutableAtom(2, 1, 2));
                    this.add(new ImmutableAtom(2, 2, 2));
                    this.add(new ImmutableAtom(3, 3, 2));
                    this.add(new ImmutableAtom(3, 3, 3));
                    this.add(new ImmutableAtom(3, 4, 2));
                    this.add(new ImmutableAtom(3, 4, 3));
                    this.add(new ImmutableAtom(4, 5, 4));
                    this.add(new ImmutableAtom(5, 5, 5));
                    this.add(new ImmutableAtom(5, 6, 5));
                    this.add(new ImmutableAtom(6, 6, 6));
                    this.add(new ImmutableAtom(6, 7, 6));
                    this.add(new ImmutableAtom(7, 7, 7));
                    this.add(new ImmutableAtom(7, 7, 10));
                    this.add(new ImmutableAtom(7, 8, 7));
                    this.add(new ImmutableAtom(7, 8, 10));
                    this.add(new ImmutableAtom(8, 8, 8));
                    this.add(new ImmutableAtom(8, 8, 10));
                    this.add(new ImmutableAtom(8, 9, 8));
                    this.add(new ImmutableAtom(8, 9, 10));
                    this.add(new ImmutableAtom(8, 10, 8));
                    this.add(new ImmutableAtom(8, 10, 10));
                    this.add(new ImmutableAtom(9, 10, 9));
                    this.add(new ImmutableAtom(9, 10, 10));
                    this.add(new ImmutableAtom(10, 10, 10));
                    this.add(new ImmutableAtom(10, 11, 10));
                    this.add(new ImmutableAtom(10, 12, 10));
                    this.add(new ImmutableAtom(11, 12, 10));
                    this.add(new ImmutableAtom(11, 12, 11));
                    this.add(new ImmutableAtom(12, 12, 10));
                    this.add(new ImmutableAtom(12, 12, 12));
                    this.add(new ImmutableAtom(12, 13, 10));
                    this.add(new ImmutableAtom(12, 13, 12));
                    this.add(new ImmutableAtom(12, 14, 10));
                    this.add(new ImmutableAtom(12, 14, 12));
                    this.add(new ImmutableAtom(13, 14, 10));
                    this.add(new ImmutableAtom(13, 14, 13));
                    this.add(new ImmutableAtom(14, 14, 14));
                    this.add(new ImmutableAtom(14, 15, 14));
                    this.add(new ImmutableAtom(14, 16, 14));
                    this.add(new ImmutableAtom(15, 16, 15));
                    this.add(new ImmutableAtom(16, 16, 16));
                    this.add(new ImmutableAtom(16, 16, 18));
                    this.add(new ImmutableAtom(16, 17, 16));
                    this.add(new ImmutableAtom(16, 17, 18));
                    this.add(new ImmutableAtom(16, 18, 16));
                    this.add(new ImmutableAtom(16, 18, 18));
                    this.add(new ImmutableAtom(16, 19, 16));
                    this.add(new ImmutableAtom(16, 19, 18));
                    this.add(new ImmutableAtom(17, 18, 17));
                    this.add(new ImmutableAtom(17, 18, 18));
                    this.add(new ImmutableAtom(17, 20, 17));
                    this.add(new ImmutableAtom(17, 20, 18));
                    this.add(new ImmutableAtom(18, 20, 18));
                    this.add(new ImmutableAtom(18, 22, 18));
                }
            });
            this.put(4, new ArrayList<ImmutableAtom>(){
                {
                    this.add(new ImmutableAtom(1, 0, 0));
                    this.add(new ImmutableAtom(1, 0, 1));
                    this.add(new ImmutableAtom(1, 0, 2));
                    this.add(new ImmutableAtom(1, 1, 0));
                    this.add(new ImmutableAtom(1, 1, 1));
                    this.add(new ImmutableAtom(1, 1, 2));
                    this.add(new ImmutableAtom(2, 1, 2));
                    this.add(new ImmutableAtom(2, 2, 2));
                    this.add(new ImmutableAtom(3, 3, 2));
                    this.add(new ImmutableAtom(3, 3, 3));
                    this.add(new ImmutableAtom(3, 4, 2));
                    this.add(new ImmutableAtom(3, 4, 3));
                    this.add(new ImmutableAtom(4, 5, 4));
                    this.add(new ImmutableAtom(5, 5, 5));
                    this.add(new ImmutableAtom(5, 6, 5));
                    this.add(new ImmutableAtom(6, 6, 6));
                    this.add(new ImmutableAtom(6, 7, 6));
                    this.add(new ImmutableAtom(7, 7, 7));
                    this.add(new ImmutableAtom(7, 7, 10));
                    this.add(new ImmutableAtom(7, 8, 7));
                    this.add(new ImmutableAtom(7, 8, 10));
                    this.add(new ImmutableAtom(8, 8, 8));
                    this.add(new ImmutableAtom(8, 8, 10));
                    this.add(new ImmutableAtom(8, 9, 8));
                    this.add(new ImmutableAtom(8, 9, 10));
                    this.add(new ImmutableAtom(8, 10, 8));
                    this.add(new ImmutableAtom(8, 10, 10));
                    this.add(new ImmutableAtom(9, 10, 9));
                    this.add(new ImmutableAtom(9, 10, 10));
                    this.add(new ImmutableAtom(10, 10, 10));
                    this.add(new ImmutableAtom(10, 11, 10));
                    this.add(new ImmutableAtom(10, 12, 10));
                    this.add(new ImmutableAtom(11, 12, 10));
                    this.add(new ImmutableAtom(11, 12, 11));
                    this.add(new ImmutableAtom(12, 12, 10));
                    this.add(new ImmutableAtom(12, 12, 12));
                    this.add(new ImmutableAtom(12, 13, 10));
                    this.add(new ImmutableAtom(12, 13, 12));
                    this.add(new ImmutableAtom(12, 14, 10));
                    this.add(new ImmutableAtom(12, 14, 12));
                    this.add(new ImmutableAtom(13, 14, 10));
                    this.add(new ImmutableAtom(13, 14, 13));
                    this.add(new ImmutableAtom(14, 14, 14));
                    this.add(new ImmutableAtom(14, 15, 14));
                    this.add(new ImmutableAtom(14, 16, 14));
                    this.add(new ImmutableAtom(15, 16, 15));
                    this.add(new ImmutableAtom(16, 16, 16));
                    this.add(new ImmutableAtom(16, 16, 18));
                    this.add(new ImmutableAtom(16, 17, 16));
                    this.add(new ImmutableAtom(16, 17, 18));
                    this.add(new ImmutableAtom(16, 18, 16));
                    this.add(new ImmutableAtom(16, 18, 18));
                    this.add(new ImmutableAtom(16, 19, 16));
                    this.add(new ImmutableAtom(16, 19, 18));
                    this.add(new ImmutableAtom(17, 18, 17));
                    this.add(new ImmutableAtom(17, 18, 18));
                    this.add(new ImmutableAtom(17, 20, 17));
                    this.add(new ImmutableAtom(17, 20, 18));
                    this.add(new ImmutableAtom(18, 20, 18));
                    this.add(new ImmutableAtom(18, 22, 18));
                }
            });
        }
    };
    private ProblemSet problemSet;
    private final ConstantDtClock clock = new ConstantDtClock(1000, 1000.0);
    private final HashMap<Integer, Double> mapLevelToBestTime = new HashMap();

    public BuildAnAtomGameModel() {
        this.setState(this.gameSettingsState);
    }

    public State getGameSettingsState() {
        return this.gameSettingsState;
    }

    public void setState(State state) {
        if (this.currentState != state) {
            State state2 = this.currentState;
            state2.teardown();
            this.currentState = state;
            this.currentState.init();
            for (GameModelListener gameModelListener : this.listeners) {
                gameModelListener.stateChanged(state2, this.currentState);
            }
        }
    }

    public State getState() {
        return this.currentState;
    }

    public GameSettings getGameSettings() {
        return this.gameSettings;
    }

    public int getLevel() {
        return (Integer)this.gameSettings.level.get();
    }

    public boolean isTimerEnabled() {
        return (Boolean)this.gameSettings.timerEnabled.get();
    }

    public boolean isSoundEnabled() {
        return (Boolean)this.gameSettings.soundEnabled.get();
    }

    public void startGame() {
        this.problemSet = new ProblemSet(this, 5);
        if (this.problemSet.getTotalNumProblems() > 0) {
            this.setState(this.problemSet.getCurrentProblem());
        } else {
            this.setState(this.gameOverState);
        }
        this.scoreProperty.reset();
        this.getGameClock().resetSimulationTime();
        this.getGameClock().start();
    }

    public void stopGame() {
        this.getGameClock().stop();
        if (this.isTimerEnabled() && (!this.mapLevelToBestTime.containsKey(this.getLevel()) || this.getGameClock().getSimulationTime() < this.mapLevelToBestTime.get(this.getLevel()))) {
            this.mapLevelToBestTime.put(this.getLevel(), this.getGameClock().getSimulationTime());
        }
    }

    public void addListener(GameModelListener gameModelListener) {
        this.listeners.add(gameModelListener);
    }

    public void newGame() {
        this.setState(this.gameSettingsState);
    }

    public State getGameOverState() {
        return this.gameOverState;
    }

    public void processGuess(ImmutableAtom immutableAtom) {
        this.problemSet.getCurrentProblem().processGuess(immutableAtom);
        this.scoreProperty.set(this.scoreProperty.get() + this.problemSet.getCurrentProblem().getScore());
    }

    public Property<Integer> getScoreProperty() {
        return this.scoreProperty;
    }

    public ArrayList<ImmutableAtom> getLevelPool() {
        return this.levelPools.get(this.getLevel());
    }

    public int getProblemIndex(Problem problem) {
        return this.problemSet.getProblemIndex(problem);
    }

    public int getNumberProblems() {
        return this.problemSet.getTotalNumProblems();
    }

    public void next() {
        if (this.problemSet.isLastProblem()) {
            this.setState(this.getGameOverState());
        } else {
            this.setState(this.problemSet.nextProblem());
        }
    }

    public int getScore() {
        return this.scoreProperty.get();
    }

    public int getMaximumPossibleScore() {
        return 10;
    }

    public ConstantDtClock getGameClock() {
        return this.clock;
    }

    public long getTime() {
        return (long)this.clock.getSimulationTime();
    }

    public long getBestTime(int n) {
        assert (n > 0 && n <= 4);
        return (long)(this.mapLevelToBestTime.containsKey(n) ? this.mapLevelToBestTime.get(n) : 9.223372036854776E18);
    }

    public boolean isNewBestTime() {
        return this.getTime() == this.getBestTime(this.getLevel()) && this.isTimerEnabled();
    }

    public boolean isBestTimeRecorded(int n) {
        return this.mapLevelToBestTime.containsKey(n);
    }

    public static interface GameModelListener {
        public void stateChanged(State var1, State var2);
    }
}

