/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.BuildAnAtomClock;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.modules.game.model.SimpleAtom;

public class ImmutableAtom
implements IAtom {
    private final int protons;
    private final int neutrons;
    private final int electrons;

    public ImmutableAtom(int n, int n2, int n3) {
        this.protons = n;
        this.neutrons = n2;
        this.electrons = n3;
    }

    public int getNumProtons() {
        return this.protons;
    }

    public int getNumNeutrons() {
        return this.neutrons;
    }

    public int getNumElectrons() {
        return this.electrons;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ImmutableAtom immutableAtom = (ImmutableAtom)object;
        if (this.electrons != immutableAtom.electrons) {
            return false;
        }
        if (this.neutrons != immutableAtom.neutrons) {
            return false;
        }
        return this.protons == immutableAtom.protons;
    }

    public int hashCode() {
        int n = this.protons;
        n = n * 31 + this.neutrons;
        n = n * 31 + this.electrons;
        return n;
    }

    public SimpleAtom toAtom(BuildAnAtomClock buildAnAtomClock) {
        assert (this.protons >= 0 && this.neutrons >= 0 && this.electrons >= 0);
        return new SimpleAtom(this.protons, this.neutrons, this.electrons);
    }

    public int getMassNumber() {
        return this.protons + this.neutrons;
    }

    public int getCharge() {
        return this.protons - this.electrons;
    }

    public boolean isNeutral() {
        return this.getCharge() == 0;
    }

    public String toString() {
        return new String("protons: " + this.protons + ", neutrons: " + this.neutrons + ", electrons: " + this.electrons + ", charge: " + this.getCharge());
    }

    public String getFormattedCharge() {
        if (this.getCharge() <= 0) {
            return "" + this.getCharge();
        }
        return "+" + this.getCharge();
    }

    public String getName() {
        return AtomIdentifier.getName(this);
    }

    public String getSymbol() {
        return AtomIdentifier.getSymbol(this);
    }

    public boolean isStable() {
        return AtomIdentifier.isStable(this);
    }

    public double getAtomicMass() {
        return AtomIdentifier.getAtomicMass(this);
    }

    public double getNaturalAbundance() {
        return AtomIdentifier.getNaturalAbundance(this);
    }
}

