/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.developer;

import edu.colorado.phet.buildanatom.modules.game.model.ProblemType;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ProblemTypeSelectionDialog
extends PaintImmediateDialog {
    private final ArrayList<ProblemTypeCheckBox> checkBoxList = new ArrayList<ProblemTypeCheckBox>(){
        {
            this.add(new ProblemTypeCheckBox("Schematic To Symbol All Problem Allowed", ProblemType.SCHEMATIC_TO_SYMBOL_ALL));
            this.add(new ProblemTypeCheckBox("Schematic To Symbol Charge Problem Allowed", ProblemType.SCHEMATIC_TO_SYMBOL_CHARGE));
            this.add(new ProblemTypeCheckBox("Schematic To Symbol Mass Problem Allowed", ProblemType.SCHEMATIC_TO_SYMBOL_MASS));
            this.add(new ProblemTypeCheckBox("Schematic To Symbol Proton Count Problem Allowed", ProblemType.SCHEMATIC_TO_SYMBOL_PROTON_COUNT));
            this.add(new ProblemTypeCheckBox("Schematic To Element Problem Allowed", ProblemType.SCHEMATIC_TO_ELEMENT));
            this.add(new ProblemTypeCheckBox("Schematic To Charge Question Problem Allowed", ProblemType.SCHEMATIC_TO_CHARGE_QUESTION));
            this.add(new ProblemTypeCheckBox("Schematic To Mass Question Problem Allowed", ProblemType.SCHEMATIC_TO_MASS_QUESTION));
            this.add(new ProblemTypeCheckBox("Symbol To Schematic Problem Allowed", ProblemType.SYMBOL_TO_SCHEMATIC));
            this.add(new ProblemTypeCheckBox("Symbol To Counts Problem Allowed", ProblemType.SYMBOL_TO_COUNTS));
            this.add(new ProblemTypeCheckBox("Counts To Charge Question Problem Allowed", ProblemType.COUNTS_TO_CHARGE_QUESTION));
            this.add(new ProblemTypeCheckBox("Counts To Mass Question Problem Allowed", ProblemType.COUNTS_TO_MASS_QUESTION));
            this.add(new ProblemTypeCheckBox("Counts To Symbol All Problem Allowed", ProblemType.COUNTS_TO_SYMBOL_ALL));
            this.add(new ProblemTypeCheckBox("Counts To Symbol Charge Problem Allowed", ProblemType.COUNTS_TO_SYMBOL_CHARGE));
            this.add(new ProblemTypeCheckBox("Counts To Symbol Mass Problem Allowed", ProblemType.COUNTS_TO_SYMBOL_MASS));
            this.add(new ProblemTypeCheckBox("Counts To Symbol Proton Count Problem Allowed", ProblemType.COUNTS_TO_SYMBOL_PROTON_COUNT));
            this.add(new ProblemTypeCheckBox("Counts To Element Problem Allowed", ProblemType.COUNTS_TO_ELEMENT));
        }
    };
    static ProblemTypeSelectionDialog instance = null;

    private ProblemTypeSelectionDialog(Frame frame) {
        super(frame, "Select Allowed Problem Types");
        this.setDefaultCloseOperation(1);
        this.setLayout(new GridLayout(this.checkBoxList.size() + 1, 1));
        for (ProblemTypeCheckBox problemTypeCheckBox : this.checkBoxList) {
            this.add(problemTypeCheckBox);
        }
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JButton("Check All"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProblemTypeSelectionDialog.this.setAllSelected();
                    }
                });
            }
        });
        jPanel.add(new JButton("Clear All"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ProblemTypeSelectionDialog.this.setNoneSelected();
                    }
                });
            }
        });
        this.add(jPanel);
        this.pack();
        this.setLocation(frame.getX(), frame.getHeight() / 2 + frame.getY() - this.getHeight() / 2);
    }

    public static ProblemTypeSelectionDialog getInstance() {
        assert (instance != null);
        return instance;
    }

    public static ProblemTypeSelectionDialog createInstance(Frame frame) {
        if (instance == null) {
            instance = new ProblemTypeSelectionDialog(frame);
        } else {
            System.err.println("Warning: Multiple attempts to create this singleton.");
        }
        return instance;
    }

    public boolean isProblemTypeAllowed(ProblemType problemType) {
        AbstractButton abstractButton = null;
        for (ProblemTypeCheckBox problemTypeCheckBox : this.checkBoxList) {
            if (problemType != problemTypeCheckBox.getProblemType()) continue;
            abstractButton = problemTypeCheckBox;
            break;
        }
        if (abstractButton == null) {
            System.err.println(this.getClass().getName() + " - Error: No check box found for problem type " + (Object)((Object)problemType));
            return false;
        }
        return abstractButton.isSelected();
    }

    public void setAllSelected() {
        for (ProblemTypeCheckBox problemTypeCheckBox : this.checkBoxList) {
            problemTypeCheckBox.setSelected(true);
        }
    }

    private void setNoneSelected() {
        for (ProblemTypeCheckBox problemTypeCheckBox : this.checkBoxList) {
            problemTypeCheckBox.setSelected(false);
        }
    }

    private static class ProblemTypeCheckBox
    extends JCheckBox {
        private final ProblemType problemType;

        public ProblemTypeCheckBox(String string, ProblemType problemType) {
            super(string, true);
            this.problemType = problemType;
        }

        public ProblemType getProblemType() {
            return this.problemType;
        }
    }
}

