/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.developer.DeveloperConfiguration;
import edu.colorado.phet.buildanatom.modules.interactiveisotope.MakeIsotopesModule;
import edu.colorado.phet.buildanatom.modules.isotopemixture.MixIsotopesModule;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class IsotopesAndAtomicMassApplication
extends PiccoloPhetApplication {
    public static final BooleanProperty whiteIsotopeBoxProperty = new BooleanProperty(false);

    public IsotopesAndAtomicMassApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        this.addModule(new MakeIsotopesModule());
        this.addModule(new MixIsotopesModule());
    }

    private void initMenubar() {
        PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(BuildAnAtomStrings.WHITE_ISOTOPE_BOX){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        whiteIsotopeBoxProperty.set(this.isSelected());
                    }
                });
            }
        };
        optionsMenu.add(jCheckBoxMenuItem);
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Animate Unstable Nucleus"){
            {
                this.setSelected((Boolean)DeveloperConfiguration.ANIMATE_UNSTABLE_NUCLEUS_PROPERTY.get());
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DeveloperConfiguration.ANIMATE_UNSTABLE_NUCLEUS_PROPERTY.set(this.isSelected());
                    }
                });
            }
        };
        jMenu.add(jCheckBoxMenuItem2);
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        new PhetApplicationLauncher().launchSim(stringArray, "build-an-atom", "isotopes-and-atomic-mass", IsotopesAndAtomicMassApplication.class);
    }
}

