/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public abstract class ShapeRenderer {
    protected Viewer viewer;
    protected JmolRendererInterface g3d;
    protected ModelSet modelSet;
    protected Shape shape;
    protected int myVisibilityFlag;
    protected int shapeID;
    protected short colix;
    protected short mad;
    protected int exportType;

    public final void setViewerG3dShapeID(Viewer viewer, JmolRendererInterface jmolRendererInterface, int n) {
        this.viewer = viewer;
        this.g3d = jmolRendererInterface;
        this.shapeID = n;
        this.myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(n);
        this.initRenderer();
    }

    protected void initRenderer() {
    }

    public void render(JmolRendererInterface jmolRendererInterface, ModelSet modelSet, Shape shape) {
        this.g3d = jmolRendererInterface;
        this.modelSet = modelSet;
        this.shape = shape;
        this.exportType = jmolRendererInterface.getExportType();
        this.render();
        this.exportType = 0;
    }

    protected abstract void render();
}

