/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.simsharing;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingDragPoints;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class SimSharingDragHandler
extends PDragSequenceEventHandler {
    protected final IUserComponent userComponent;
    protected final IUserComponentType componentType;
    private final SimSharingDragPoints dragPoints;
    private DragFunction startDragFunction;
    private DragFunction dragFunction;
    private DragFunction endDragFunction;

    public SimSharingDragHandler(IUserComponent iUserComponent, IUserComponentType iUserComponentType, final boolean bl) {
        this.userComponent = iUserComponent;
        this.componentType = iUserComponentType;
        this.dragPoints = new SimSharingDragPoints();
        this.startDragFunction = new DragFunction(){

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                SimSharingManager.sendUserMessage(iUserComponent, iUserComponentType, iUserAction, parameterSet);
            }
        };
        this.dragFunction = new DragFunction(){

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                if (bl) {
                    SimSharingManager.sendUserMessage(iUserComponent, iUserComponentType, iUserAction, parameterSet);
                }
            }
        };
        this.endDragFunction = new DragFunction(){

            public void apply(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet, PInputEvent pInputEvent) {
                SimSharingManager.sendUserMessage(iUserComponent, iUserComponentType, iUserAction, parameterSet);
            }
        };
    }

    protected void startDrag(PInputEvent pInputEvent) {
        this.clearDragPoints();
        this.addDragPoint(pInputEvent);
        this.startDragFunction.apply(this.userComponent, this.componentType, UserActions.startDrag, this.getStartDragParameters(pInputEvent), pInputEvent);
        super.startDrag(pInputEvent);
    }

    protected void drag(PInputEvent pInputEvent) {
        this.addDragPoint(pInputEvent);
        this.dragFunction.apply(this.userComponent, this.componentType, UserActions.drag, this.getDragParameters(pInputEvent), pInputEvent);
        super.drag(pInputEvent);
    }

    protected void endDrag(PInputEvent pInputEvent) {
        this.addDragPoint(pInputEvent);
        this.endDragFunction.apply(this.userComponent, this.componentType, UserActions.endDrag, this.getEndDragParameters(pInputEvent), pInputEvent);
        this.clearDragPoints();
        super.endDrag(pInputEvent);
    }

    protected ParameterSet getStartDragParameters(PInputEvent pInputEvent) {
        return this.getParametersForAllEvents(pInputEvent);
    }

    protected ParameterSet getDragParameters(PInputEvent pInputEvent) {
        return this.getParametersForAllEvents(pInputEvent);
    }

    protected ParameterSet getEndDragParameters(PInputEvent pInputEvent) {
        return this.getParametersForAllEvents(pInputEvent).with(this.dragPoints.getParameters());
    }

    protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
        return new ParameterSet().with(SimSharingDragHandler.getXParameter(pInputEvent)).with(SimSharingDragHandler.getYParameter(pInputEvent));
    }

    private void addDragPoint(PInputEvent pInputEvent) {
        this.dragPoints.add(SimSharingDragHandler.getPosition(pInputEvent));
    }

    private void clearDragPoints() {
        this.dragPoints.clear();
    }

    private static Parameter getXParameter(PInputEvent pInputEvent) {
        return new Parameter((IParameterKey)ParameterKeys.canvasPositionX, SimSharingDragHandler.getPosition(pInputEvent).getX());
    }

    private static Parameter getYParameter(PInputEvent pInputEvent) {
        return new Parameter((IParameterKey)ParameterKeys.canvasPositionY, SimSharingDragHandler.getPosition(pInputEvent).getY());
    }

    private static Point2D getPosition(PInputEvent pInputEvent) {
        return pInputEvent.getCanvasPosition();
    }

    public static interface DragFunction {
        public void apply(IUserComponent var1, IUserComponentType var2, IUserAction var3, ParameterSet var4, PInputEvent var5);
    }
}

