/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicHTML;

public class ToolTipNode
extends PComposite {
    private static final int DEFAULT_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
    private static final Font DEFAULT_FONT = new PhetFont(12);
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Paint DEFAULT_STROKE_PAINT = new Color(0, 0, 0, 200);
    private static final Paint DEFAULT_BACKGROUND_PAINT = new Color(255, 255, 204);
    private static final Paint DEFAULT_BACKGROUND_SHADOW_PAINT = new Color(0, 0, 0, 100);
    private final PNode _associatedNode;
    private boolean _enabled;
    private Timer _showToolTipTimer;
    private IToolTipLocationStrategy _locationStrategy;
    private PNode toolTipTextNode;
    private PPath _backgroundNode;
    private PPath _backgroundShadowNode;
    private double _margin;

    public ToolTipNode(String string, PNode pNode) {
        this(string, pNode, DEFAULT_INITIAL_DELAY);
    }

    public ToolTipNode(String string, PNode pNode, int n) {
        this(string, pNode, n, DEFAULT_FONT, DEFAULT_TEXT_COLOR, DEFAULT_STROKE, DEFAULT_STROKE_PAINT, DEFAULT_BACKGROUND_PAINT, DEFAULT_BACKGROUND_SHADOW_PAINT, 5.0);
    }

    protected ToolTipNode(String string, PNode pNode, final int n, Font font, Color color, Stroke stroke, Paint paint, Paint paint2, Paint paint3, double d) {
        this.setVisible(false);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._margin = d;
        this._associatedNode = pNode;
        this._enabled = true;
        if (BasicHTML.isHTMLString(string)) {
            HTMLNode hTMLNode = new HTMLNode(string);
            hTMLNode.setFont(font);
            hTMLNode.setHTMLColor(color);
            this.toolTipTextNode = hTMLNode;
        } else {
            PText pText = new PText(string);
            pText.setFont(font);
            pText.setTextPaint(color);
            this.toolTipTextNode = pText;
        }
        this._backgroundNode = new PPath();
        this._backgroundNode.setStroke(stroke);
        this._backgroundNode.setStrokePaint(paint);
        this._backgroundNode.setPaint(paint2);
        this._backgroundShadowNode = new PPath();
        this._backgroundShadowNode.setStroke(null);
        this._backgroundShadowNode.setPaint(paint3);
        this._backgroundShadowNode.setOffset(2.0, 2.0);
        this.updateBackgroundNodeShapes();
        this.addChild(this._backgroundShadowNode);
        this.addChild(this._backgroundNode);
        this.addChild(this.toolTipTextNode);
        this.toolTipTextNode.setOffset(d, d);
        this._locationStrategy = new CenteredAboveMouseCursor();
        pNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(final PInputEvent pInputEvent) {
                if (ToolTipNode.this.isEnabled()) {
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ToolTipNode.this._locationStrategy.setToolTipLocation(ToolTipNode.this, ToolTipNode.this._associatedNode, pInputEvent);
                            ToolTipNode.this.setVisible(true);
                        }
                    };
                    ToolTipNode.this._showToolTipTimer = new Timer(n, actionListener);
                    ToolTipNode.this._showToolTipTimer.setInitialDelay(n);
                    ToolTipNode.this._showToolTipTimer.setRepeats(false);
                    ToolTipNode.this._showToolTipTimer.start();
                }
            }

            public void mousePressed(PInputEvent pInputEvent) {
                this.hideToolTip();
            }

            public void mouseExited(PInputEvent pInputEvent) {
                this.hideToolTip();
            }

            private void hideToolTip() {
                ToolTipNode.this.setVisible(false);
                if (ToolTipNode.this._showToolTipTimer != null) {
                    ToolTipNode.this._showToolTipTimer.stop();
                    ToolTipNode.this._showToolTipTimer = null;
                }
            }
        });
    }

    private void updateBackgroundNodeShapes() {
        PBounds pBounds = this.toolTipTextNode.getFullBoundsReference();
        double d = pBounds.getWidth() + 2.0 * this._margin;
        double d2 = pBounds.getHeight() + 2.0 * this._margin;
        this._backgroundNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
        this._backgroundShadowNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public static class CenteredAboveMouseCursor
    implements IToolTipLocationStrategy {
        public void setToolTipLocation(ToolTipNode toolTipNode, PNode pNode, PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getPosition();
            Point2D point2D2 = toolTipNode.getParent().globalToLocal(point2D);
            double d = point2D2.getX() - toolTipNode.getFullBoundsReference().getWidth() / 2.0;
            double d2 = point2D2.getY() - toolTipNode.getFullBoundsReference().getHeight();
            toolTipNode.setOffset(d, d2);
        }
    }

    public static interface IToolTipLocationStrategy {
        public void setToolTipLocation(ToolTipNode var1, PNode var2, PInputEvent var3);
    }
}

