/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.module;

import edu.colorado.phet.boundstates.control.ZoomControl;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.util.AxisSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.text.DecimalFormat;
import org.jfree.data.Range;

public class BSOneWellSpec
extends BSAbstractModuleSpec {
    private static final BSWellType[] WELL_TYPES = new BSWellType[]{BSWellType.SQUARE, BSWellType.ASYMMETRIC, BSWellType.COULOMB_1D, BSWellType.COULOMB_3D, BSWellType.HARMONIC_OSCILLATOR};
    private static final BSWellType DEFAULT_WELL_TYPE = BSWellType.SQUARE;
    private static final DoubleRange MASS_MULTIPLIER_RANGE = new DoubleRange(0.5, 1.1, 1.0, 2);
    private static final IntegerRange NUMBER_OF_WELLS_RANGE = new IntegerRange(1, 1, 1);
    private static final DoubleRange FIELD_CONSTANT_RANGE = new DoubleRange(-1.0, 1.0, 0.0, 1);
    private static final Range ASYMMETRIC_ENERGY_RANGE = new Range(-5.5, 15.5);
    private static final DecimalFormat ASYMMETRIC_ENERGY_TICK_FORMAT = new DecimalFormat("#0");
    private static final DoubleRange ASYMMETRIC_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange ASYMMETRIC_WIDTH_RANGE = new DoubleRange(0.1, 6.0, 1.0, 1);
    private static final DoubleRange ASYMMETRIC_HEIGHT_RANGE = new DoubleRange(0.0, 20.0, 10.0, 1);
    private static final Range COULOMB_1D_ENERGY_RANGE = new Range(-15.5, 5.5);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT = new DecimalFormat("#0");
    private static final DoubleRange COULOMB_1D_OFFSET_RANGE = new DoubleRange(-15.0, 5.0, 0.0, 1);
    private static final DoubleRange COULOMB_1D_SPACING_RANGE = new DoubleRange(0.0, 0.0, 0.0, 0);
    private static final Range COULOMB_3D_ENERGY_RANGE = new Range(-15.5, 5.5);
    private static final DecimalFormat COULOMB_3D_ENERGY_TICK_FORMAT = new DecimalFormat("#0");
    private static final DoubleRange COULOMB_3D_OFFSET_RANGE = new DoubleRange(-15.0, 5.0, 0.0, 1);
    private static final Range HARMONIC_OSCILLATOR_ENERGY_RANGE = new Range(-5.5, 15.5);
    private static final DecimalFormat HARMONIC_OSCILLATOR_ENERGY_TICK_FORMAT = new DecimalFormat("#0");
    private static final DoubleRange HARMONIC_OSCILLATOR_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange HARMONIC_OSCILLATOR_ANGULAR_FREQUENCY_RANGE = new DoubleRange(1.0, 10.0, 1.0, 1);
    private static final Range SQUARE_ENERGY_RANGE = new Range(-5.5, 15.5);
    private static final DecimalFormat SQUARE_ENERGY_TICK_FORMAT = new DecimalFormat("#0");
    private static final DoubleRange SQUARE_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange SQUARE_WIDTH_RANGE = new DoubleRange(0.1, 6.0, 1.0, 1);
    private static final DoubleRange SQUARE_HEIGHT_RANGE = new DoubleRange(0.0, 20.0, 10.0, 1);
    private static final DoubleRange SQUARE_SEPARATION_RANGE = new DoubleRange(0.0, 0.0, 0.0, 0);

    public BSOneWellSpec() {
        this.setId("oneWellModule");
        this.setWellTypes(WELL_TYPES);
        this.setDefaultWellType(DEFAULT_WELL_TYPE);
        this.setNumberOfWellsSupported(false);
        this.setOffsetControlSupported(true);
        this.setSuperpositionControlsSupported(true);
        this.setParticleControlsSupported(true);
        this.setMagnifyingGlassSupported(true);
        this.setMagnifyingGlassSelected(false);
        this.setAverageProbabilityDensityIsSupported(false);
        this.setFieldConstantSupported(false);
        this.setMassMultiplierRange(MASS_MULTIPLIER_RANGE);
        this.setNumberOfWellsRange(NUMBER_OF_WELLS_RANGE);
        this.setFieldConstantRange(FIELD_CONSTANT_RANGE);
        this.setMagnification(10.0);
        AxisSpec axisSpec = new AxisSpec(ASYMMETRIC_ENERGY_RANGE, 5.0, ASYMMETRIC_ENERGY_TICK_FORMAT);
        ZoomControl.ZoomSpec zoomSpec = new ZoomControl.ZoomSpec(axisSpec);
        BSPotentialSpec bSPotentialSpec = new BSPotentialSpec.Asymmetric(zoomSpec, ASYMMETRIC_OFFSET_RANGE, ASYMMETRIC_WIDTH_RANGE, ASYMMETRIC_HEIGHT_RANGE);
        this.setAsymmetricSpec(bSPotentialSpec);
        axisSpec = new AxisSpec(COULOMB_1D_ENERGY_RANGE, 5.0, COULOMB_1D_ENERGY_TICK_FORMAT);
        zoomSpec = new ZoomControl.ZoomSpec(axisSpec);
        bSPotentialSpec = new BSPotentialSpec.Coulomb1D(zoomSpec, COULOMB_1D_OFFSET_RANGE, COULOMB_1D_SPACING_RANGE);
        this.setCoulomb1DSpec(bSPotentialSpec);
        axisSpec = new AxisSpec(COULOMB_3D_ENERGY_RANGE, 5.0, COULOMB_3D_ENERGY_TICK_FORMAT);
        zoomSpec = new ZoomControl.ZoomSpec(axisSpec);
        bSPotentialSpec = new BSPotentialSpec.Coulomb3D(zoomSpec, COULOMB_3D_OFFSET_RANGE);
        this.setCoulomb3DSpec(bSPotentialSpec);
        axisSpec = new AxisSpec(HARMONIC_OSCILLATOR_ENERGY_RANGE, 5.0, HARMONIC_OSCILLATOR_ENERGY_TICK_FORMAT);
        zoomSpec = new ZoomControl.ZoomSpec(axisSpec);
        bSPotentialSpec = new BSPotentialSpec.HarmonicOscillator(zoomSpec, HARMONIC_OSCILLATOR_OFFSET_RANGE, HARMONIC_OSCILLATOR_ANGULAR_FREQUENCY_RANGE);
        this.setHarmonicOscillatorSpec(bSPotentialSpec);
        axisSpec = new AxisSpec(SQUARE_ENERGY_RANGE, 5.0, SQUARE_ENERGY_TICK_FORMAT);
        zoomSpec = new ZoomControl.ZoomSpec(axisSpec);
        bSPotentialSpec = new BSPotentialSpec.Square(zoomSpec, SQUARE_OFFSET_RANGE, SQUARE_WIDTH_RANGE, SQUARE_HEIGHT_RANGE, SQUARE_SEPARATION_RANGE);
        this.setSquareSpec(bSPotentialSpec);
    }
}

