/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.model.BSObservable;
import java.util.ArrayList;
import java.util.Iterator;

public class BSSuperpositionCoefficients
extends BSObservable {
    private ArrayList _coefficients = new ArrayList();

    public BSSuperpositionCoefficients() {
    }

    public BSSuperpositionCoefficients(BSSuperpositionCoefficients bSSuperpositionCoefficients) {
        this();
        this._coefficients.clear();
        Iterator iterator = bSSuperpositionCoefficients._coefficients.iterator();
        while (iterator.hasNext()) {
            this._coefficients.add(iterator.next());
        }
    }

    public double[] getCoefficients() {
        double[] dArray = new double[this.getNumberOfCoefficients()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getCoefficient(i);
        }
        return dArray;
    }

    public void setNumberOfCoefficients(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numberOfCoefficients must be >= 0: " + n);
        }
        int n2 = this.getNumberOfCoefficients();
        boolean bl = false;
        int n3 = 0;
        if (n != n2) {
            int n4;
            if (n == 0) {
                this._coefficients.clear();
                bl = true;
                n3 = 1;
            } else if (n2 == 0) {
                this._coefficients.clear();
                this._coefficients.add(new Double(1.0));
                for (n4 = 1; n4 < n; ++n4) {
                    this._coefficients.add(new Double(0.0));
                }
                bl = true;
                n3 = 1;
            } else if (n > n2) {
                for (n4 = this.getNumberOfCoefficients(); n4 < n; ++n4) {
                    this._coefficients.add(new Double(0.0));
                }
                bl = true;
                n3 = 0;
            } else {
                n4 = 0;
                for (int i = n2 - 1; i >= n; --i) {
                    double d = (Double)this._coefficients.get(i);
                    if (d != 0.0) {
                        n4 = 1;
                    }
                    this._coefficients.remove(i);
                }
                if (n4 != 0) {
                    if (this.getSum() == 0.0) {
                        if (n > 0) {
                            this._coefficients.set(0, new Double(1.0));
                        }
                    } else {
                        this.normalize();
                    }
                }
                bl = true;
                n3 = n4;
            }
            String string = null;
            if (n3 != 0) {
                string = "superpositionCoefficientsValues";
            } else if (bl) {
                string = "superpositionCoefficientsCount";
            }
            this.notifyObservers(string);
        }
    }

    public int getNumberOfCoefficients() {
        return this._coefficients.size();
    }

    public int getNumberOfNonZeroCoefficients() {
        int n = 0;
        for (Double d : this._coefficients) {
            if (d == 0.0) continue;
            ++n;
        }
        return n;
    }

    public double getCoefficient(int n) {
        if (n > this._coefficients.size() - 1) {
            throw new IndexOutOfBoundsException("index is out of bounds: " + n);
        }
        return (Double)this._coefficients.get(n);
    }

    public void setCoefficient(int n, double d) {
        if (n > this._coefficients.size() - 1) {
            throw new IndexOutOfBoundsException("index is out of bounds: " + n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("value must be between 0 and 1: " + d);
        }
        this._coefficients.set(n, new Double(d));
        this.notifyObservers("superpositionCoefficientsValues");
    }

    public void setOneCoefficient(int n) {
        if (n > this._coefficients.size() - 1) {
            throw new IndexOutOfBoundsException("index is out of bounds: " + n);
        }
        boolean bl = this.isNotifyEnabled();
        this.setNotifyEnabled(false);
        this.setAllZero();
        this.setCoefficient(n, 1.0);
        this.setNotifyEnabled(bl);
        this.notifyObservers("superpositionCoefficientsValues");
    }

    public void normalize() {
        double d = this.getSumOfSquares();
        if (d != 0.0) {
            boolean bl = this.isNotifyEnabled();
            this.setNotifyEnabled(false);
            int n = this.getNumberOfCoefficients();
            for (int i = 0; i < n; ++i) {
                double d2 = this.getCoefficient(i);
                double d3 = Math.sqrt(d2 * d2 / d);
                this.setCoefficient(i, d3);
            }
            this.setNotifyEnabled(bl);
            this.notifyObservers("superpositionCoefficientsValues");
        }
    }

    public boolean isNormalized(double d) {
        double d2 = this.getSumOfSquares();
        double d3 = Math.abs(1.0 - d2);
        return d3 <= d;
    }

    public double getSum() {
        double d = 0.0;
        int n = this.getNumberOfCoefficients();
        for (int i = 0; i < n; ++i) {
            d += this.getCoefficient(i);
        }
        return d;
    }

    private double getSumOfSquares() {
        double d = 0.0;
        int n = this.getNumberOfCoefficients();
        for (int i = 0; i < n; ++i) {
            double d2 = this.getCoefficient(i);
            d += d2 * d2;
        }
        return d;
    }

    public boolean isSuperpositionState() {
        return this.getNumberOfNonZeroCoefficients() > 1;
    }

    public void setAllZero() {
        boolean bl = this.isNotifyEnabled();
        this.setNotifyEnabled(false);
        int n = this.getNumberOfCoefficients();
        for (int i = 0; i < n; ++i) {
            this.setCoefficient(i, 0.0);
        }
        this.setNotifyEnabled(bl);
        this.notifyObservers("superpositionCoefficientsValues");
    }

    public int getLowestNonZeroCoefficientIndex() {
        int n = this.getNumberOfCoefficients();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            double d = this.getCoefficient(i);
            if (d == 0.0) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void setBandCoefficients(int n, int n2, double d) {
        int n3;
        this.setNotifyEnabled(false);
        int n4 = this.getNumberOfCoefficients();
        for (n3 = 0; n3 < n4; ++n3) {
            this.setCoefficient(n3, 0.0);
        }
        if (n != -1) {
            for (int i = n3 = n * n2; i < n3 + n2 && i < n4; ++i) {
                this.setCoefficient(i, d);
            }
        }
        this.setNotifyEnabled(true);
    }
}

