/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.model.BSAbstractCoulombSolver;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSParticle;

public class BSCoulomb1DSolver
extends BSAbstractCoulombSolver {
    private static final double[] SCALING_COEFFICIENTS = new double[]{1.10851, -1.86636, 2.55958, -3.21387, 3.84064, -4.44633, 5.03504, -5.6096, 6.17208, -6.72406};

    public BSCoulomb1DSolver(BSAbstractPotential bSAbstractPotential, BSParticle bSParticle) {
        super(bSAbstractPotential, bSParticle);
    }

    public int getMaxEigenstates() {
        return SCALING_COEFFICIENTS.length;
    }

    public static double getScalingCoefficient(int n) {
        if (n < 1 || n > SCALING_COEFFICIENTS.length) {
            throw new IndexOutOfBoundsException("no scaling coefficient for n=" + n);
        }
        return SCALING_COEFFICIENTS[n - 1];
    }

    protected double psiScaled(int n, double d) {
        double d2 = BSCoulomb1DSolver.getScalingCoefficient(n);
        return Math.sqrt(5.68 / this.getMass()) * d2 * d * this.psi(n, d);
    }
}

