/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSBlackColorScheme;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.color.BSColorsMenu;
import edu.colorado.phet.boundstates.module.BSAbstractModule;
import edu.colorado.phet.boundstates.module.BSManyWellsModule;
import edu.colorado.phet.boundstates.module.BSOneWellModule;
import edu.colorado.phet.boundstates.module.BSTwoWellsModule;
import edu.colorado.phet.boundstates.persistence.BSConfig;
import edu.colorado.phet.boundstates.persistence.BSGlobalConfig;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetFrameWorkaround;
import edu.colorado.phet.common.phetcommon.view.menu.HelpMenu;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;

public abstract class BSAbstractApplication
extends PiccoloPhetApplication {
    private BSOneWellModule _oneWellModule;
    private BSTwoWellsModule _twoWellsModule;
    private BSManyWellsModule _manyWellsModule;
    private XMLPersistenceManager _persistenceManager;
    private BSColorsMenu _colorsMenu;

    public BSAbstractApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    protected abstract void initModules();

    private void initMenubar() {
        PhetFrame phetFrame = this.getPhetFrame();
        phetFrame.addFileSaveLoadMenuItems();
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(phetFrame);
        }
        this._colorsMenu = new BSColorsMenu(this);
        if (BSConstants.COLOR_SCHEME instanceof BSBlackColorScheme) {
            this._colorsMenu.selectBlack();
        } else {
            this._colorsMenu.selectWhite();
        }
        this.getPhetFrame().addMenu(this._colorsMenu);
        HelpMenu helpMenu = this.getPhetFrame().getHelpMenu();
        if (helpMenu != null) {
            // empty if block
        }
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        Module[] moduleArray = this.getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            if (!(moduleArray[i] instanceof BSAbstractModule)) continue;
            ((BSAbstractModule)moduleArray[i]).setColorScheme(bSColorScheme);
        }
    }

    protected void addOneWellModule() {
        this._oneWellModule = new BSOneWellModule();
        this.addModule(this._oneWellModule);
    }

    public BSAbstractModule getOneWellModule() {
        return this._oneWellModule;
    }

    protected void addTwoWellsModule() {
        this._twoWellsModule = new BSTwoWellsModule();
        this.addModule(this._twoWellsModule);
    }

    public BSAbstractModule getTwoWellsModule() {
        return this._twoWellsModule;
    }

    protected void addManyWellsModule() {
        this._manyWellsModule = new BSManyWellsModule();
        this.addModule(this._manyWellsModule);
    }

    public BSAbstractModule getManyWellsModule() {
        return this._manyWellsModule;
    }

    public void startApplication() {
        super.startApplication();
    }

    protected PhetFrame createPhetFrame() {
        return new PhetFrameWorkaround(this);
    }

    public void save() {
        BSConfig bSConfig = new BSConfig();
        BSGlobalConfig bSGlobalConfig = new BSGlobalConfig();
        bSConfig.setGlobalConfig(bSGlobalConfig);
        bSGlobalConfig.setApplicationClassName(this.getClass().getName());
        bSGlobalConfig.setVersionNumber(this.getSimInfo().getVersion().toString());
        bSGlobalConfig.setColorSchemeName(this._colorsMenu.getColorSchemeName());
        bSGlobalConfig.setColorScheme(this._colorsMenu.getColorScheme());
        Module module = this.getActiveModule();
        assert (module instanceof BSAbstractModule);
        BSAbstractModule bSAbstractModule = (BSAbstractModule)module;
        bSGlobalConfig.setActiveModuleId(bSAbstractModule.getId());
        if (this._oneWellModule != null) {
            bSConfig.setOneWellModuleConfig(this._oneWellModule.save());
        }
        if (this._twoWellsModule != null) {
            bSConfig.setTwoWellsModuleConfig(this._twoWellsModule.save());
        }
        if (this._manyWellsModule != null) {
            bSConfig.setManyWellsModuleConfig(this._manyWellsModule.save());
        }
        this._persistenceManager.save(bSConfig);
    }

    public void load() {
        Object object = this._persistenceManager.load();
        if (object != null) {
            if (object instanceof BSConfig) {
                BSConfig bSConfig = (BSConfig)object;
                BSGlobalConfig bSGlobalConfig = bSConfig.getGlobalConfig();
                String string = bSGlobalConfig.getColorSchemeName();
                BSColorScheme bSColorScheme = bSGlobalConfig.getColorScheme().toBSColorScheme();
                this._colorsMenu.setColorScheme(string, bSColorScheme);
                String string2 = bSGlobalConfig.getActiveModuleId();
                Module[] moduleArray = this.getModules();
                for (int i = 0; i < moduleArray.length; ++i) {
                    assert (moduleArray[i] instanceof BSAbstractModule);
                    BSAbstractModule bSAbstractModule = (BSAbstractModule)moduleArray[i];
                    if (!string2.equals(bSAbstractModule.getId())) continue;
                    this.setActiveModule(bSAbstractModule);
                    break;
                }
                if (this._oneWellModule != null) {
                    this._oneWellModule.load(bSConfig.getOneWellModuleConfig());
                }
                if (this._twoWellsModule != null) {
                    this._twoWellsModule.load(bSConfig.getTwoWellsModuleConfig());
                }
                if (this._manyWellsModule != null) {
                    this._manyWellsModule.load(bSConfig.getManyWellsModuleConfig());
                }
            } else {
                String string = BSResources.getString("message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }
}

