/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.DraggableSensorNode;
import edu.colorado.phet.common.piccolophet.nodes.VelocitySensor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocitySensorNode
extends DraggableSensorNode<Vector2D> {
    private final VelocitySensor velocitySensor;

    public VelocitySensorNode(ModelViewTransform modelViewTransform, VelocitySensor velocitySensor, double d, ObservableProperty<Function1<Vector2D, String>> observableProperty, Vector2D vector2D) {
        this(modelViewTransform, velocitySensor, d, observableProperty, new Function1.Identity<Point2D>(), PhetCommonResources.PICCOLO_PHET_VELOCITY_SENSOR_NODE_UNKNOWN, vector2D);
    }

    public VelocitySensorNode(final ModelViewTransform modelViewTransform, final VelocitySensor velocitySensor, final double d, ObservableProperty<Function1<Vector2D, String>> observableProperty, Function1<Point2D, Point2D> function1, String string, Vector2D vector2D) {
        super(modelViewTransform, velocitySensor, observableProperty, function1, string, PhetCommonResources.PICCOLO_PHET_VELOCITY_SENSOR_NODE_SPEED, vector2D);
        this.velocitySensor = velocitySensor;
        this.addChild(new ArrowNode(new Point2D.Double(), new Point2D.Double(100.0, 100.0), 20.0, 20.0, 10.0, 0.75, true){
            {
                super(point2D, point2D2, d6, d2, d3, d4, bl);
                this.setPaint(Color.blue);
                this.setStrokePaint(Color.black);
                this.setStroke(new BasicStroke(1.0f));
                final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Option option = (Option)velocitySensor.value.get();
                        if (option.isNone()) {
                            this.setVisible(false);
                        } else {
                            Vector2D vector2D = modelViewTransform.modelToViewDelta((Vector2D)option.get()).times(d);
                            this.setTipAndTailLocations(VelocitySensorNode.this.velocityPointNode.getFullBounds().getCenterX() + vector2D.getX(), VelocitySensorNode.this.velocityPointNode.getFullBounds().getMaxY() + vector2D.getY(), VelocitySensorNode.this.velocityPointNode.getFullBounds().getCenterX(), VelocitySensorNode.this.velocityPointNode.getFullBounds().getMaxY());
                            this.setVisible(true);
                        }
                    }
                };
                VelocitySensorNode.this.velocityPointNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
                velocitySensor.value.addObserver(new SimpleObserver(){

                    public void update() {
                        propertyChangeListener.propertyChange(null);
                    }
                });
            }
        });
    }
}

