/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.awt.geom.AffineTransform;

public class ThreeImageNode
extends PNode {
    public final PImage leftPatch;
    public final PImage centerPatch;
    public final PImage rightPatch;
    private final Property<Double> centerWidth;

    public ThreeImageNode(Image image, Image image2, Image image3) {
        this(image, image2, image3, image2.getWidth(null));
    }

    public ThreeImageNode(Image image, Image image2, Image image3, double d) {
        this.centerWidth = new Property<Double>(d);
        this.leftPatch = new PImage(image);
        this.addChild(this.leftPatch);
        this.centerPatch = new PImage(image2);
        this.addChild(this.centerPatch);
        this.rightPatch = new PImage(image3);
        this.addChild(this.rightPatch);
        this.setCenterWidth(d);
    }

    public void setCenterWidth(double d) {
        if (d != this.centerWidth.get()) {
            this.centerPatch.setTransform(new AffineTransform());
            double d2 = d / this.centerPatch.getFullBounds().getWidth();
            this.centerPatch.setTransform(AffineTransform.getScaleInstance(d2, 1.0));
            this.centerPatch.translate(this.leftPatch.getFullBounds().getMaxX() / d2, 0.0);
            this.rightPatch.setOffset(this.leftPatch.getFullBounds().getWidth() + d, 0.0);
            this.centerWidth.set(d);
        }
    }

    public void addCenterWidthObserver(SimpleObserver simpleObserver) {
        this.centerWidth.addObserver(simpleObserver);
    }
}

