/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.nodes.PointSensor;
import edu.colorado.phet.common.piccolophet.nodes.ThreeImageNode;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorNode<T>
extends ToolNode {
    public final ModelViewTransform transform;
    public final PointSensor<T> pointSensor;
    public final ThreeImageNode bodyNode;
    public final PImage velocityPointNode;
    public final BufferedImage velocityPoint;

    public SensorNode(final ModelViewTransform modelViewTransform, final PointSensor<T> pointSensor, final ObservableProperty<Function1<T, String>> observableProperty, final String string, String string2, final T t) {
        this.transform = modelViewTransform;
        this.pointSensor = pointSensor;
        this.bodyNode = new ThreeImageNode(PiccoloPhetApplication.RESOURCES.getImage("velocity_left.png"), PiccoloPhetApplication.RESOURCES.getImage("velocity_center.png"), PiccoloPhetApplication.RESOURCES.getImage("velocity_right.png"));
        this.addChild(this.bodyNode);
        final PText pText = new PText(string2){
            {
                this.setFont(new PhetFont(22));
                SensorNode.this.bodyNode.addCenterWidthObserver(new SimpleObserver(){

                    public void update() {
                        this.setOffset(SensorNode.this.bodyNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, 7.0);
                    }
                });
            }
        };
        this.addChild(pText);
        this.addChild(new PText(){
            {
                this.setFont(new PhetFont(26));
                final SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.setOffset(SensorNode.this.bodyNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, 38.0);
                    }
                };
                SensorNode.this.bodyNode.addCenterWidthObserver(simpleObserver);
                new RichSimpleObserver(){

                    public void update() {
                        double d = 0.0;
                        if (t != null) {
                            this.setText((String)((Function1)observableProperty.get()).apply(t));
                            d = this.getFullBounds().getWidth();
                        }
                        this.setText(string);
                        double d2 = this.getFullBounds().getWidth();
                        double d3 = pText.getFullBounds().getWidth();
                        SensorNode.this.bodyNode.setCenterWidth(Math.max(Math.max(d3, d), d2) + 10.0);
                    }
                }.observe(observableProperty);
                new RichSimpleObserver(){

                    public void update() {
                        Option option = pointSensor.value.get();
                        this.setText(option.isNone() ? string : (String)((Function1)observableProperty.get()).apply(option.get()));
                        simpleObserver.update();
                    }
                }.observe(observableProperty, pointSensor.value);
            }
        });
        this.velocityPoint = PiccoloPhetApplication.RESOURCES.getImage("velocity_point.png");
        this.velocityPointNode = new PImage(this.velocityPoint){
            {
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.setOffset(SensorNode.this.bodyNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, SensorNode.this.bodyNode.getFullBounds().getMaxY());
                    }
                };
                SensorNode.this.bodyNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
                propertyChangeListener.propertyChange(null);
            }
        };
        this.addChild(this.velocityPointNode);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                Point2D.Double double_ = modelViewTransform.modelToView(pointSensor.position.get()).toPoint2D();
                SensorNode.this.setOffset(double_.getX() - SensorNode.this.bodyNode.getFullBounds().getWidth() / 2.0, double_.getY() - SensorNode.this.bodyNode.getFullBounds().getHeight() - (double)SensorNode.this.velocityPoint.getHeight());
            }
        };
        pointSensor.position.addObserver(simpleObserver);
        this.bodyNode.addCenterWidthObserver(simpleObserver);
    }

    @Override
    public void dragAll(PDimension pDimension) {
        this.pointSensor.translate(this.transform.viewToModelDelta(pDimension));
    }
}

