/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.view;

import edu.colorado.phet.bendinglight.BendingLightApplication;
import edu.colorado.phet.bendinglight.model.Laser;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.And;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotationDragHandle
extends PNode {
    public RotationDragHandle(final ModelViewTransform modelViewTransform, final Laser laser, final double d, BooleanProperty booleanProperty, final Function1<Double, Boolean> function1) {
        CompositeProperty<Boolean> compositeProperty = new CompositeProperty<Boolean>(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return (Boolean)function1.apply(laser.getAngle());
            }
        }, laser.emissionPoint, laser.pivot);
        final And and = booleanProperty.and(compositeProperty);
        and.addObserver(new SimpleObserver(){

            public void update() {
                RotationDragHandle.this.setVisible((Boolean)and.get());
            }
        });
        final BufferedImage bufferedImage = BufferedImageUtils.flipY(BufferedImageUtils.flipX(BendingLightApplication.RESOURCES.getImage("laser.png")));
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                RotationDragHandle.this.removeAllChildren();
                PNode pNode = new PNode(){
                    {
                        double d = modelViewTransform.modelToViewDeltaX(laser.getDistanceFromPivot()) + (double)bufferedImage.getWidth() * 0.85;
                        Point2D.Double double_ = modelViewTransform.modelToView(laser.pivot.get()).toPoint2D();
                        double d2 = Math.toDegrees(laser.getAngle());
                        Arc2D.Double double_2 = new Arc2D.Double(-d + ((Point2D)double_).getX(), -d + ((Point2D)double_).getY(), 2.0 * d, 2.0 * d, d2, d, 0);
                        Shape shape = new BasicStroke(10.0f, 0, 0).createStrokedShape(double_2);
                        double d3 = 0.1;
                        Vector2D vector2D = new Vector2D(double_).plus(Vector2D.createPolar(d, Math.toRadians(-d2 - d * (1.0 - d3))));
                        Vector2D vector2D2 = new Vector2D(double_).plus(Vector2D.createPolar(d, Math.toRadians(-d2 - d * 1.1)));
                        final GeneralPath generalPath = new Arrow((Point2D)vector2D.toPoint2D(), vector2D2.toPoint2D(), 20.0, 20.0, 0.0, 1.0, false).getShape();
                        Area area = new Area(shape){
                            {
                                super(shape);
                                this.add(new Area(generalPath));
                            }
                        };
                        this.addChild(new PhetPPath(area, Color.green, new BasicStroke(1.0f), Color.black));
                        this.setPickable(false);
                        this.setChildrenPickable(false);
                    }
                };
                RotationDragHandle.this.addChild(pNode);
            }
        };
        laser.emissionPoint.addObserver(simpleObserver);
    }
}

