/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.view;

import edu.colorado.phet.bendinglight.BendingLightApplication;
import edu.colorado.phet.bendinglight.model.ProtractorModel;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.CanvasBoundedDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtractorNode
extends ToolNode {
    private final ModelViewTransform transform;
    private final ProtractorModel protractorModel;
    private final BufferedImage image;
    private double scale;
    protected final Rectangle2D.Double innerBarShape;
    private boolean debug = false;

    public ProtractorNode(ModelViewTransform modelViewTransform, final Property<Boolean> property, final ProtractorModel protractorModel, Function2<Shape, Shape, Shape> function2, Function2<Shape, Shape, Shape> function22, double d, double d2) {
        this.scale = d;
        this.transform = modelViewTransform;
        this.protractorModel = protractorModel;
        this.image = BufferedImageUtils.multiScale(BendingLightApplication.RESOURCES.getImage("protractor.png"), d2);
        PImage pImage = new PImage(this.image){
            {
                super(image);
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        ProtractorNode.this.setVisible((Boolean)property.get());
                    }
                });
                this.setPickable(false);
            }
        };
        this.addChild(pImage);
        final Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, this.image.getWidth(), this.image.getHeight());
        Area area = new Area(double_){
            {
                super(shape);
                double d = (double)ProtractorNode.this.image.getWidth() * 0.3;
                double d2 = (double)ProtractorNode.this.image.getHeight() * 0.3;
                this.subtract(new Area(new Ellipse2D.Double(double_.getCenterX() - d, double_.getCenterY() - d2, d * 2.0, d2 * 2.0)));
            }
        };
        this.innerBarShape = new Rectangle2D.Double(20.0, double_.getCenterY(), double_.getWidth() - 40.0, 90.0);
        if (this.debug) {
            this.addChild(new PhetPPath((Shape)this.innerBarShape, (Paint)new Color(0, 255, 0, 128)));
        }
        this.addChild(new PhetPPath(function2.apply(this.innerBarShape, area), (Paint)(this.debug ? Color.blue : new Color(0, 0, 0, 0))){
            {
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new CanvasBoundedDragHandler(ProtractorNode.this){

                    public void dragNode(DragEvent dragEvent) {
                        ProtractorNode.this.dragAll(dragEvent.delta);
                    }
                });
            }
        });
        this.addChild(new PhetPPath(function22.apply(this.innerBarShape, area), this.debug ? Color.red : new Color(0, 0, 0, 0)){
            {
                super(shape, paint);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){
                    Point2D start = null;

                    public void mousePressed(PInputEvent pInputEvent) {
                        this.start = pInputEvent.getPositionRelativeTo(this.getParent());
                    }

                    public void mouseDragged(PInputEvent pInputEvent) {
                        Point2D point2D = pInputEvent.getPositionRelativeTo(this.getParent());
                        double d = new Vector2D(this.getFullBounds().getCenter2D(), this.start).getAngle();
                        double d2 = new Vector2D(this.getFullBounds().getCenter2D(), point2D).getAngle();
                        double d3 = d2 - d;
                        protractorModel.angle.set(protractorModel.angle.get() + d3);
                    }
                });
            }
        });
        new RichSimpleObserver(){

            public void update() {
                ProtractorNode.this.updateTransform();
            }
        }.observe(protractorModel.position, protractorModel.angle);
    }

    protected void setProtractorScale(double d) {
        this.scale = d;
        this.updateTransform();
    }

    protected void updateTransform() {
        this.setTransform(new AffineTransform());
        this.setScale(this.scale);
        Point2D.Double double_ = this.transform.modelToView(this.protractorModel.position.get()).toPoint2D();
        this.setOffset(((Point2D)double_).getX() - (double)(this.image.getWidth() / 2) * this.scale, ((Point2D)double_).getY() - (double)(this.image.getHeight() / 2) * this.scale);
        this.rotateAboutPoint(this.protractorModel.angle.get(), this.image.getWidth() / 2, this.image.getHeight() / 2);
    }

    public static BufferedImage newProtractorImage(int n) {
        return BufferedImageUtils.multiScaleToHeight(BendingLightApplication.RESOURCES.getImage("protractor.png"), n);
    }

    @Override
    public void dragAll(PDimension pDimension) {
        this.protractorModel.translate(this.transform.viewToModelDelta(new Vector2D(pDimension.width, pDimension.height)));
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setPickable(bl);
        this.setChildrenPickable(bl);
    }
}

