/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.view;

import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.model.BendingLightModel;
import edu.colorado.phet.bendinglight.model.DispersionFunction;
import edu.colorado.phet.bendinglight.model.Medium;
import edu.colorado.phet.bendinglight.model.MediumColorFactory;
import edu.colorado.phet.bendinglight.model.MediumState;
import edu.colorado.phet.bendinglight.view.BendingLightCanvas;
import edu.colorado.phet.bendinglight.view.TickLabel;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPComboBox;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediumControlPanel
extends PNode {
    private final MediumState CUSTOM = new MediumState(BendingLightStrings.CUSTOM, BendingLightModel.MYSTERY_B.getIndexOfRefractionForRedLight() + 1.2, false, true);
    private final Property<Medium> medium;
    private final Property<Double> laserWavelength;
    private double lastNonMysteryIndexAtRed;

    public MediumControlPanel(final PhetPCanvas phetPCanvas, final Property<Medium> property, final String string, final boolean bl, final Property<Double> property2, final String string2, final int n) {
        this.medium = property;
        this.laserWavelength = property2;
        final MediumState mediumState = property.get().getMediumState();
        this.lastNonMysteryIndexAtRed = mediumState.getIndexOfRefractionForRedLight();
        property.addObserver(new VoidFunction1<Medium>(){

            @Override
            public void apply(Medium medium) {
                if (!medium.isMystery()) {
                    MediumControlPanel.this.lastNonMysteryIndexAtRed = medium.getIndexOfRefraction(6.5E-7);
                }
            }
        });
        PNode pNode = new PNode(){
            {
                final PText pText = new PText(string){
                    {
                        this.setFont(new PhetFont(BendingLightCanvas.labelFont.getSize(), true));
                    }
                };
                final Object[] objectArray = new Object[]{BendingLightModel.AIR, BendingLightModel.WATER, BendingLightModel.GLASS, BendingLightModel.MYSTERY_A, BendingLightModel.MYSTERY_B, MediumControlPanel.this.CUSTOM};
                final PhetPComboBox phetPComboBox = new PhetPComboBox(objectArray){
                    {
                        super(objectArray3);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                MediumState mediumState = (MediumState)this.getSelectedItem();
                                if (!mediumState.custom) {
                                    MediumControlPanel.this.setMediumState(mediumState);
                                } else {
                                    MediumControlPanel.this.setMediumState(new MediumState(mediumState.name, MediumControlPanel.this.lastNonMysteryIndexAtRed, mediumState.mystery, mediumState.custom));
                                }
                            }
                        });
                        this.updateComboBox();
                        property.addObserver(new SimpleObserver(){

                            public void update() {
                                this.updateComboBox();
                            }
                        });
                        this.setFont(BendingLightCanvas.labelFont);
                        MediumControlPanel.this.setMediumState(mediumState);
                    }

                    private void updateComboBox() {
                        int n = -1;
                        for (int i = 0; i < objectArray.length; ++i) {
                            MediumState mediumState = (MediumState)objectArray[i];
                            if (mediumState.dispersionFunction.getIndexOfRefraction((Double)property2.get()) != ((Medium)property.get()).getIndexOfRefraction((Double)property2.get())) continue;
                            n = i;
                        }
                        if (n != -1 && !((Medium)property.get()).getMediumState().custom) {
                            this.setSelectedIndex(n);
                        } else {
                            this.setSelectedItem(MediumControlPanel.this.CUSTOM);
                        }
                    }
                };
                PSwing pSwing = new PSwing(phetPComboBox){
                    {
                        super(jComponent);
                        phetPComboBox.setEnvironment(this, phetPCanvas);
                        this.setOffset(pText.getFullBounds().getMaxX() + 10.0, pText.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0 + 1.0);
                    }
                };
                this.addChild(pText);
                this.addChild(pSwing);
            }
        };
        this.addChild(pNode);
        final PNode pNode2 = new PNode(){
            {
                final PNode pNode = new PNode(){
                    {
                        final PText pText = new PText(bl ? BendingLightStrings.INDEX_OF_REFRACTION_COLON : BendingLightStrings.INDEX_OF_REFRACTION){
                            {
                                this.setFont(BendingLightCanvas.labelFont);
                            }
                        };
                        this.addChild(pText);
                        if (bl) {
                            this.addChild(new PSwing(new JTextField(new DecimalFormat(string2).format(((Medium)property.get()).getIndexOfRefraction((Double)property2.get())), n){
                                {
                                    this.setFont(BendingLightCanvas.labelFont);
                                    this.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent actionEvent) {
                                            double d = Double.parseDouble(this.getText());
                                            double d2 = MathUtil.clamp(1.0, d, 1.6);
                                            MediumControlPanel.this.setCustomIndexOfRefraction(d2);
                                            MediumControlPanel.this.setCustomIndexOfRefraction(d2);
                                        }
                                    });
                                    new RichSimpleObserver(){

                                        public void update() {
                                            this.setText(new DecimalFormat(string2).format(((Medium)property.get()).getIndexOfRefraction((Double)property2.get())));
                                        }
                                    }.observe(property, property2);
                                }
                            }){
                                {
                                    super(jComponent);
                                    this.setOffset(pText.getFullBounds().getMaxX() + 10.0, pText.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                                }
                            });
                        }
                    }
                };
                this.addChild(pNode);
                this.addChild(new PSwing(new JPanel(){
                    {
                        this.setLayout(null);
                        class 1LowHighLabel
                        extends JLabel {
                            1LowHighLabel(String string, boolean bl) {
                                super(string);
                                this.setFont(new PhetFont(14));
                                this.setVisible(bl);
                            }
                        }
                        1LowHighLabel lowHighLabel = new 1LowHighLabel(BendingLightStrings.LOW, !bl);
                        1LowHighLabel lowHighLabel2 = new 1LowHighLabel(BendingLightStrings.HIGH, !bl);
                        JSlider jSlider = new JSlider(0, 10000){
                            {
                                final Function.LinearFunction linearFunction = new Function.LinearFunction(this.getMinimum(), this.getMaximum(), 1.0, 1.6);
                                this.addChangeListener(new ChangeListener(){

                                    public void stateChanged(ChangeEvent changeEvent) {
                                        if (this.isFocusOwner()) {
                                            double d = linearFunction.evaluate(this.getValue());
                                            MediumControlPanel.this.setCustomIndexOfRefraction(d);
                                        }
                                    }
                                });
                                new RichSimpleObserver(){

                                    public void update() {
                                        this.setValue((int)linearFunction.createInverse().evaluate(((Medium)property.get()).getIndexOfRefraction((Double)property2.get())));
                                    }
                                }.observe(property, property2);
                                this.setPaintTicks(true);
                                this.setPaintLabels(true);
                                this.setLabelTable(new Hashtable<Object, Object>(){
                                    {
                                        this.put((int)linearFunction.createInverse().evaluate(BendingLightModel.AIR.getIndexOfRefractionForRedLight()), new TickLabel(BendingLightStrings.AIR));
                                        this.put((int)linearFunction.createInverse().evaluate(BendingLightModel.WATER.getIndexOfRefractionForRedLight()), new TickLabel(BendingLightStrings.WATER));
                                        this.put((int)linearFunction.createInverse().evaluate(BendingLightModel.GLASS.getIndexOfRefractionForRedLight()), new TickLabel(BendingLightStrings.GLASS));
                                    }
                                });
                                this.setPreferredSize(new Dimension(Math.max((int)pNode.getFullBounds().getWidth(), 200), this.getPreferredSize().height));
                            }
                        };
                        lowHighLabel.setBounds(0, 0, lowHighLabel.getPreferredSize().width, lowHighLabel.getPreferredSize().height);
                        jSlider.setBounds(lowHighLabel.getPreferredSize().width, 0, jSlider.getPreferredSize().width, jSlider.getPreferredSize().height);
                        lowHighLabel2.setBounds(lowHighLabel.getPreferredSize().width + jSlider.getPreferredSize().width, 0, lowHighLabel2.getPreferredSize().width, lowHighLabel2.getPreferredSize().height);
                        this.add(jSlider);
                        this.add(lowHighLabel);
                        this.add(lowHighLabel2);
                        this.setPreferredSize(new Dimension(lowHighLabel.getPreferredSize().width + jSlider.getPreferredSize().width + lowHighLabel2.getPreferredSize().width, jSlider.getPreferredSize().height));
                    }
                }){
                    {
                        super(jComponent);
                        this.setOffset(0.0, pNode.getFullBounds().getMaxY());
                    }
                });
                this.setOffset(0.0, pNode.getFullBounds().getMaxY() + 10.0);
                pNode.setOffset(this.getFullBounds().getWidth() / 2.0 - pNode.getFullBounds().getWidth() / 2.0, 0.0);
            }
        };
        property.addObserver(new SimpleObserver(){

            public void update() {
                pNode2.setVisible(!((Medium)property.get()).isMystery());
            }
        });
        PText pText = new PText(BendingLightStrings.N_UNKNOWN){
            {
                super(string);
                this.setFont(BendingLightCanvas.labelFont);
                this.centerFullBoundsOnPoint(pNode2.getFullBounds().getCenterX(), pNode2.getFullBounds().getCenterY());
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(((Medium)property.get()).isMystery());
                    }
                });
            }
        };
        this.addChild(pNode2);
        this.addChild(pText);
        pNode.setOffset(this.getFullBounds().getCenterX() - pNode.getFullBounds().getWidth() / 2.0, 0.0);
        pNode.setOffset(this.getFullBounds().getCenterX() - pNode.getFullBounds().getWidth() / 2.0, 0.0);
    }

    private void setCustomIndexOfRefraction(double d) {
        DispersionFunction dispersionFunction = new DispersionFunction(d, this.laserWavelength.get());
        this.setMedium(new Medium(this.medium.get().shape, new MediumState(BendingLightStrings.CUSTOM, dispersionFunction, false, true), MediumColorFactory.getColor(dispersionFunction.getIndexOfRefractionForRed())));
    }

    private void setMediumState(MediumState mediumState) {
        this.setMedium(new Medium(this.medium.get().shape, mediumState, MediumColorFactory.getColor(mediumState.getIndexOfRefractionForRedLight())));
    }

    private void setMedium(Medium medium) {
        this.medium.set(medium);
    }
}

