/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.view;

import edu.colorado.phet.bendinglight.model.LightRay;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class LightRayNode
extends PNode {
    private final LightRay lightRay;
    private Point2D viewStart;
    private Point2D viewEnd;

    public LightRayNode(final ModelViewTransform modelViewTransform, final LightRay lightRay) {
        this.lightRay = lightRay;
        Color color = lightRay.getColor();
        PhetPPath phetPPath = new PhetPPath(new BasicStroke((float)modelViewTransform.modelToViewDeltaX(lightRay.getRayWidth())), new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.sqrt(lightRay.getPowerFraction()))){
            {
                super(stroke, paint);
                LightRayNode.this.viewStart = modelViewTransform.modelToView(lightRay.tip.toPoint2D());
                LightRayNode.this.viewEnd = modelViewTransform.modelToView(lightRay.tail.toPoint2D());
                this.setPathTo(LightRayNode.this.getLine());
            }
        };
        this.addChild(phetPPath);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public Line2D.Double getLine() {
        return new Line2D.Double(this.viewStart, this.viewEnd);
    }

    public Color getColor() {
        return this.lightRay.getColor();
    }

    public LightRay getLightRay() {
        return this.lightRay;
    }
}

