/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.view;

import edu.colorado.phet.bendinglight.BendingLightApplication;
import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.model.IntensityMeter;
import edu.colorado.phet.bendinglight.view.WireNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.CanvasBoundedDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class IntensityMeterNode
extends ToolNode {
    private final ModelViewTransform transform;
    private final IntensityMeter intensityMeter;
    public PImage bodyNode;
    public PImage sensorNode;
    private boolean debug = false;

    public IntensityMeterNode(final ModelViewTransform modelViewTransform, final IntensityMeter intensityMeter) {
        this.transform = modelViewTransform;
        this.intensityMeter = intensityMeter;
        intensityMeter.enabled.addObserver(new SimpleObserver(){

            public void update() {
                IntensityMeterNode.this.setVisible(intensityMeter.enabled.get());
            }
        });
        this.sensorNode = new PImage(BendingLightApplication.RESOURCES.getImage("intensity_meter_probe.png")){
            {
                super(image);
                intensityMeter.sensorPosition.addObserver(new SimpleObserver(){

                    public void update() {
                        Point2D.Double double_ = modelViewTransform.modelToView(intensityMeter.sensorPosition.get()).toPoint2D();
                        this.setOffset(double_.getX() - this.getFullBounds().getWidth() / 2.0, double_.getY() - this.getFullBounds().getHeight() * 0.32);
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new CanvasBoundedDragHandler(IntensityMeterNode.this){

                    protected void dragNode(DragEvent dragEvent) {
                        intensityMeter.translateSensor(modelViewTransform.viewToModelDelta(dragEvent.delta));
                    }
                });
            }
        };
        this.bodyNode = new PImage(BendingLightApplication.RESOURCES.getImage("intensity_meter_box.png")){
            {
                super(image);
                intensityMeter.bodyPosition.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setOffset(modelViewTransform.modelToView(intensityMeter.bodyPosition.get()).toPoint2D());
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new CanvasBoundedDragHandler(IntensityMeterNode.this){

                    protected void dragNode(DragEvent dragEvent) {
                        intensityMeter.translateBody(modelViewTransform.viewToModelDelta(dragEvent.delta));
                    }
                });
            }
        };
        this.bodyNode.addChild(new PText(BendingLightStrings.INTENSITY){
            {
                this.setFont(new PhetFont(22));
                this.setTextPaint(Color.white);
                this.setOffset(IntensityMeterNode.this.bodyNode.getFullBounds().getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, IntensityMeterNode.this.bodyNode.getFullBounds().getHeight() * 0.1);
            }
        });
        this.bodyNode.addChild(new PText("-"){
            {
                super(string);
                this.setFont(new PhetFont(30));
                intensityMeter.reading.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setTransform(new AffineTransform());
                        this.setText(intensityMeter.reading.get().getString());
                        this.setOffset(IntensityMeterNode.this.bodyNode.getFullBounds().getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, IntensityMeterNode.this.bodyNode.getFullBounds().getHeight() * 0.44);
                    }
                });
            }
        });
        this.addChild(new WireNode(this.sensorNode, this.bodyNode, Color.gray));
        this.addChild(this.bodyNode);
        this.addChild(this.sensorNode);
        if (this.debug) {
            this.addChild(new PhetPPath(new BasicStroke(1.0f), Color.green){
                {
                    super(stroke, paint);
                    intensityMeter.sensorPosition.addObserver(new SimpleObserver(){

                        public void update() {
                            this.setPathTo(modelViewTransform.modelToView(intensityMeter.getSensorShape()));
                        }
                    });
                    this.setPickable(false);
                    this.setChildrenPickable(false);
                }
            });
        }
    }

    public void dragAll(PDimension pDimension) {
        this.doTranslate(this.transform.viewToModelDelta(pDimension));
    }

    public PNode[] getDroppableComponents() {
        return new PNode[]{this.bodyNode, this.sensorNode};
    }

    public void doTranslate(Dimension2D dimension2D) {
        this.intensityMeter.translateAll(dimension2D);
    }
}

