/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.view;

import edu.colorado.phet.bendinglight.model.BendingLightModel;
import edu.colorado.phet.bendinglight.model.LightRay;
import edu.colorado.phet.bendinglight.modules.prisms.WhiteLightNode;
import edu.colorado.phet.bendinglight.view.LaserColor;
import edu.colorado.phet.bendinglight.view.LaserNode;
import edu.colorado.phet.bendinglight.view.RotationDragHandle;
import edu.colorado.phet.bendinglight.view.TranslationDragHandle;
import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.model.property.And;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolboxCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BendingLightCanvas<T extends BendingLightModel>
extends BufferedPhetPCanvas
implements ToolboxCanvas {
    public static final PhetFont labelFont = new PhetFont(16);
    private PNode rootNode;
    public final BooleanProperty showNormal;
    public final BooleanProperty showProtractor = new BooleanProperty(false);
    protected final PNode mediumNode;
    protected final T model;
    protected final ModelViewTransform transform;
    protected final PDimension stageSize;
    protected final PNode lightRayLayer = new PNode();
    protected final PNode lightWaveLayer = new PNode();
    private final boolean debug = false;
    protected final PNode beforeLightLayer = new PNode();
    protected final PNode afterLightLayer = new PNode();
    protected final PNode afterLightLayer2 = new PNode();
    public final BooleanProperty playing;

    public BendingLightCanvas(final T t, BooleanProperty booleanProperty, Function1<Double, Double> function1, Function1<Double, Boolean> function12, Function1<Double, Boolean> function13, boolean bl, Function2<Shape, Shape, Shape> function2, Function2<Shape, Shape, Shape> function22, String string, double d) {
        this.showNormal = new BooleanProperty(bl);
        this.model = t;
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        this.stageSize = new PDimension(1008.0, 1008.0 * ((BendingLightModel)t).getHeight() / ((BendingLightModel)t).getWidth());
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, this.stageSize));
        double d2 = this.stageSize.getHeight() / ((BendingLightModel)t).getHeight();
        this.transform = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(this.stageSize.getWidth() / 2.0 - d, this.stageSize.getHeight() / 2.0), d2);
        this.mediumNode = new PNode();
        this.addChild(this.mediumNode);
        final VoidFunction1<LightRay> voidFunction1 = new VoidFunction1<LightRay>(){

            @Override
            public void apply(LightRay lightRay) {
                final PNode pNode = t.laserView.get().createNode(BendingLightCanvas.this.transform, lightRay);
                final PNode pNode2 = t.laserView.get().getLayer(BendingLightCanvas.this.lightRayLayer, BendingLightCanvas.this.lightWaveLayer);
                pNode2.addChild(pNode);
                lightRay.addMoveToFrontListener(new VoidFunction0(){

                    public void apply() {
                        pNode.moveToFront();
                    }
                });
                lightRay.addRemovalListener(new VoidFunction0(){

                    public void apply() {
                        pNode2.removeChild(pNode);
                    }
                });
            }
        };
        for (LightRay object2 : ((BendingLightModel)t).getRays()) {
            voidFunction1.apply(object2);
        }
        ((BendingLightModel)t).addRayAddedListener(new VoidFunction1<LightRay>(){

            @Override
            public void apply(LightRay lightRay) {
                voidFunction1.apply(lightRay);
            }
        });
        this.playing = new BooleanProperty(true);
        final And and = this.playing.and(booleanProperty);
        and.addObserver(new SimpleObserver((BendingLightModel)t){
            final /* synthetic */ BendingLightModel val$model;
            {
                this.val$model = bendingLightModel;
            }

            public void update() {
                if (((Boolean)and.get()).booleanValue()) {
                    this.val$model.getClock().start();
                } else {
                    this.val$model.getClock().pause();
                }
            }
        });
        final WhiteLightNode whiteLightNode = new WhiteLightNode(this.lightRayLayer, (int)this.stageSize.getWidth(), (int)this.stageSize.getHeight());
        this.addChild(this.beforeLightLayer);
        this.addChild(this.lightRayLayer);
        this.addChild(this.lightWaveLayer);
        this.addChild(whiteLightNode);
        this.addChild(this.afterLightLayer);
        this.addChild(this.afterLightLayer2);
        ((BendingLightModel)t).getLaser().color.addObserver(new SimpleObserver((BendingLightModel)t, whiteLightNode){
            final /* synthetic */ BendingLightModel val$model;
            final /* synthetic */ WhiteLightNode val$whiteLightNode;
            {
                this.val$model = bendingLightModel;
                this.val$whiteLightNode = whiteLightNode;
            }

            public void update() {
                boolean bl = this.val$model.getLaser().color.get() == LaserColor.WHITE_LIGHT;
                this.val$whiteLightNode.setVisible(bl);
                BendingLightCanvas.this.lightRayLayer.setVisible(!bl);
                BendingLightCanvas.this.lightWaveLayer.setVisible(!bl);
            }
        });
        BooleanProperty booleanProperty2 = new BooleanProperty(false);
        BooleanProperty booleanProperty3 = new BooleanProperty(false);
        this.addChild(new RotationDragHandle(this.transform, ((BendingLightModel)t).getLaser(), 10.0, booleanProperty2, function12));
        this.addChild(new RotationDragHandle(this.transform, ((BendingLightModel)t).getLaser(), -10.0, booleanProperty2, function13));
        double d3 = 100.0;
        this.addChild(new TranslationDragHandle(this.transform, ((BendingLightModel)t).getLaser(), -d3, 0.0, booleanProperty3));
        this.addChild(new TranslationDragHandle(this.transform, ((BendingLightModel)t).getLaser(), 0.0, -d3, booleanProperty3));
        this.addChild(new TranslationDragHandle(this.transform, ((BendingLightModel)t).getLaser(), d3, 0.0, booleanProperty3));
        this.addChild(new TranslationDragHandle(this.transform, ((BendingLightModel)t).getLaser(), 0.0, d3, booleanProperty3));
        this.addChild(new LaserNode(this.transform, ((BendingLightModel)t).getLaser(), booleanProperty2, booleanProperty3, function1, function2, function22, string, ((BendingLightModel)t).visibleModelBounds));
        final boolean[] blArray = new boolean[]{true};
        ((BendingLightModel)t).addModelUpdateListener(new VoidFunction0(){

            public void apply() {
                blArray[0] = true;
            }
        });
        Timer timer = new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (blArray[0]) {
                    whiteLightNode.updateImage();
                    blArray[0] = false;
                }
            }
        });
        timer.start();
    }

    @Override
    protected void updateLayout() {
        super.updateLayout();
        int n = 10;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n, this.getWidth() - n * 2, this.getHeight() - n * 2);
        ImmutableRectangle2D immutableRectangle2D = new ImmutableRectangle2D(this.transform.viewToModel(this.getRootNode().globalToLocal(double_)));
        ((BendingLightModel)this.model).visibleModelBounds.set(new Option.Some<ImmutableRectangle2D>(immutableRectangle2D));
    }

    @Override
    public PNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    @Override
    public void removeChild(PNode pNode) {
        this.rootNode.removeChild(pNode);
    }

    public void removeChildBehindLight(PNode pNode) {
        this.beforeLightLayer.removeChild(pNode);
    }

    public void addChildBehindLight(PNode pNode) {
        this.beforeLightLayer.addChild(pNode);
    }

    public void addChildAfterLight(PNode pNode) {
        this.afterLightLayer.addChild(pNode);
    }

    public void removeChildAfterLight(PNode pNode) {
        this.afterLightLayer.removeChild(pNode);
    }

    public T getModel() {
        return this.model;
    }

    public Function1<Point2D, Point2D> getBoundedConstraint() {
        return new Function1<Point2D, Point2D>(){

            @Override
            public Point2D apply(Point2D point2D) {
                return ((BendingLightModel)BendingLightCanvas.this.model).visibleModelBounds.getClosestPoint(point2D);
            }
        };
    }
}

