/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.prisms;

import edu.colorado.phet.bendinglight.modules.prisms.BresenhamLineAlgorithm;
import edu.colorado.phet.bendinglight.view.LightRayNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhiteLightNode
extends PImage {
    private BufferedImage buffer;
    private final PNode rayLayer;

    public WhiteLightNode(PNode pNode, int n, int n2) {
        this.buffer = new BufferedImage(n, n2, 3);
        this.rayLayer = pNode;
        this.setImage(this.buffer);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public void updateImage() {
        Graphics2D graphics2D = this.buffer.createGraphics();
        graphics2D.setBackground(new Color(0, 0, 0, 0));
        graphics2D.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        final HashMap hashMap = new HashMap();
        for (int i = 0; i < this.rayLayer.getChildrenCount(); ++i) {
            final LightRayNode lightRayNode = (LightRayNode)this.rayLayer.getChild(i);
            BresenhamLineAlgorithm bresenhamLineAlgorithm = new BresenhamLineAlgorithm(){

                public void setPixel(int n, int n2) {
                    Color color = lightRayNode.getColor();
                    double d = lightRayNode.getLightRay().getPowerFraction();
                    WhiteLightNode.this.addToMap(n, n2, color, d, hashMap);
                    WhiteLightNode.this.addToMap(n + 1, n2, color, d, hashMap);
                    WhiteLightNode.this.addToMap(n, n2 + 1, color, d, hashMap);
                }

                public boolean isOutOfBounds(int n, int n2) {
                    return n < 0 || n2 < 0 || n > WhiteLightNode.this.buffer.getWidth() || n2 > WhiteLightNode.this.buffer.getHeight();
                }
            };
            int n = (int)lightRayNode.getLine().x1;
            int n2 = (int)lightRayNode.getLine().y1;
            int n3 = (int)lightRayNode.getLine().x2;
            int n4 = (int)lightRayNode.getLine().y2;
            if (bresenhamLineAlgorithm.isOutOfBounds(n, n2)) {
                bresenhamLineAlgorithm.draw(n3, n4, n, n2);
                continue;
            }
            bresenhamLineAlgorithm.draw(n, n2, n3, n4);
        }
        float f = 0.2f;
        float f2 = 1.0f - f;
        for (Point point : hashMap.keySet()) {
            float[] fArray = (float[])hashMap.get(point);
            float f3 = fArray[3];
            float f4 = fArray[0];
            if (fArray[1] > f4) {
                f4 = fArray[1];
            }
            if (fArray[2] > f4) {
                f4 = fArray[2];
            }
            fArray[0] = (float)MathUtil.clamp(0.0, fArray[0] / f4 * 2.0f - f, f2);
            fArray[1] = (float)MathUtil.clamp(0.0, fArray[1] / f4 * 2.0f - f, f2);
            fArray[2] = (float)MathUtil.clamp(0.0, fArray[2] / f4 * 2.0f - f, f2);
            float f5 = (float)MathUtil.clamp(0.0, Math.sqrt(f3 *= f4), 1.0);
            graphics2D.setPaint(new Color(fArray[0], fArray[1], fArray[2], f5));
            graphics2D.fillRect(point.x, point.y, 1, 1);
        }
        graphics2D.dispose();
        this.setImage(this.buffer);
    }

    private void addToMap(int n, int n2, Color color, double d, HashMap<Point, float[]> hashMap) {
        float f = 0.017f;
        Point point = new Point(n, n2);
        if (!hashMap.containsKey(point)) {
            hashMap.put(point, new float[4]);
        }
        float[] fArray = hashMap.get(point);
        float[] fArray2 = color.getComponents(null);
        for (int i = 0; i < 3; ++i) {
            fArray[i] = fArray[i] + fArray2[i] * f;
        }
        fArray[3] = fArray[3] + (float)d;
    }
}

