/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.prisms;

import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.modules.prisms.Prism;
import edu.colorado.phet.bendinglight.modules.prisms.PrismBreakCanvas;
import edu.colorado.phet.bendinglight.modules.prisms.PrismBreakModel;
import edu.colorado.phet.bendinglight.modules.prisms.PrismNode;
import edu.colorado.phet.bendinglight.view.BendingLightCanvas;
import edu.colorado.phet.bendinglight.view.MediumControlPanel;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.NodeFactory;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolIconNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PrismToolboxNode
extends PNode {
    public PrismToolboxNode(PrismBreakCanvas prismBreakCanvas, ModelViewTransform modelViewTransform, PrismBreakModel prismBreakModel) {
        PText pText = new PText(BendingLightStrings.PRISMS){
            {
                this.setFont(BendingLightCanvas.labelFont);
            }
        };
        this.addChild(pText);
        HBox hBox = new HBox(new PNode[0]);
        hBox.setOffset(0.0, 5.0);
        this.addChild(hBox);
        for (Prism prism : PrismBreakModel.getPrismPrototypes()) {
            hBox.addChild(new PrismIcon(prism, prismBreakModel, modelViewTransform, prismBreakCanvas, new Function0<Rectangle2D>(){

                @Override
                public Rectangle2D apply() {
                    return PrismToolboxNode.this.getGlobalFullBounds();
                }
            }));
        }
        hBox.addChild(new MediumControlPanel(prismBreakCanvas, prismBreakModel.prismMedium, BendingLightStrings.OBJECTS, false, prismBreakModel.wavelengthProperty, "0.0000000", 8));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrismIcon
    extends ToolIconNode<BendingLightCanvas<PrismBreakModel>> {
        private final PrismBreakModel model;

        public PrismIcon(final Prism prism, final PrismBreakModel prismBreakModel, ModelViewTransform modelViewTransform, PrismBreakCanvas prismBreakCanvas, Function0<Rectangle2D> function0) {
            super(PrismIcon.toThumbnail(prism, prismBreakModel, modelViewTransform), new Property<Boolean>(Boolean.valueOf(false)){

                @Override
                public void set(Boolean bl) {
                    super.set(false);
                }
            }, modelViewTransform, prismBreakCanvas, new NodeFactory(){

                @Override
                public ToolNode createNode(ModelViewTransform modelViewTransform, Property<Boolean> property, Point2D point2D) {
                    return new PrismToolNode(modelViewTransform, prism.copy(), prismBreakModel, point2D);
                }
            }, prismBreakModel, function0, true);
            this.model = prismBreakModel;
        }

        @Override
        protected void addChild(BendingLightCanvas<PrismBreakModel> bendingLightCanvas, ToolNode toolNode) {
            bendingLightCanvas.addChildBehindLight(toolNode);
            this.model.addPrism(((PrismToolNode)toolNode).prism);
        }

        @Override
        protected void removeChild(BendingLightCanvas<PrismBreakModel> bendingLightCanvas, ToolNode toolNode) {
            bendingLightCanvas.removeChildBehindLight(toolNode);
            this.model.removePrism(((PrismToolNode)toolNode).prism);
        }

        private static Image toThumbnail(Prism prism, PrismBreakModel prismBreakModel, ModelViewTransform modelViewTransform) {
            PrismNode prismNode = new PrismNode(modelViewTransform, prism, prismBreakModel.prismMedium);
            return prismNode.toImage((int)(prismNode.getFullBounds().getWidth() * 70.0 / prismNode.getFullBounds().getHeight()), 70, null);
        }
    }

    static class PrismToolNode
    extends ToolNode {
        private final ModelViewTransform transform;
        private final Prism prism;

        PrismToolNode(ModelViewTransform modelViewTransform, Prism prism, PrismBreakModel prismBreakModel, Point2D point2D) {
            this.transform = modelViewTransform;
            this.prism = prism;
            Rectangle2D rectangle2D = prism.getBounds();
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            prism.translate(point2D.getX() - ((Point2D)double_).getX() - rectangle2D.getWidth() / 2.0, point2D.getY() - ((Point2D)double_).getY() - rectangle2D.getHeight() / 2.0);
            this.addChild(new PrismNode(modelViewTransform, prism, prismBreakModel.prismMedium));
        }

        public void dragAll(PDimension pDimension) {
            this.prism.translate(this.transform.viewToModelDelta(pDimension));
        }
    }
}

