/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.prisms;

import edu.colorado.phet.bendinglight.BendingLightApplication;
import edu.colorado.phet.bendinglight.model.Medium;
import edu.colorado.phet.bendinglight.modules.prisms.Prism;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.CanvasBoundedDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrismNode
extends PNode {
    public final Prism prism;

    public PrismNode(final ModelViewTransform modelViewTransform, final Prism prism, final Property<Medium> property) {
        this.prism = prism;
        if (prism.shape.get().getReferencePoint().isSome()) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class RotationDragHandle
            extends PNode {
                RotationDragHandle() {
                    this.addChild(new PImage(BufferedImageUtils.multiScaleToHeight(BendingLightApplication.RESOURCES.getImage("knob.png"), 18)){
                        {
                            super(image);
                            prism.shape.addObserver(new SimpleObserver(){

                                public void update() {
                                    this.setTransform(new AffineTransform());
                                    double d = new Vector2D(modelViewTransform.modelToView(prism.shape.get().getReferencePoint().get().toPoint2D()), modelViewTransform.modelToView(prism.shape.get().getRotationCenter().toPoint2D())).getAngle();
                                    Point2D.Double double_ = new Point2D.Double(-this.getFullBounds().getWidth() + 5.0, -this.getFullBounds().getHeight() / 2.0);
                                    this.translate(double_.x, double_.y);
                                    this.rotateAboutPoint(d, -double_.x, -double_.y);
                                }
                            });
                        }
                    });
                    prism.shape.addObserver(new SimpleObserver(){

                        public void update() {
                            this.setOffset(modelViewTransform.modelToView(prism.shape.get().getReferencePoint().get()).toPoint2D());
                        }
                    });
                    this.addInputEventListener(new CursorHandler());
                    this.addInputEventListener(new PBasicInputEventHandler(){
                        double previousAngle;

                        public void mousePressed(PInputEvent pInputEvent) {
                            this.previousAngle = this.getAngle(pInputEvent);
                        }

                        private double getAngle(PInputEvent pInputEvent) {
                            return new Vector2D(prism.shape.get().getRotationCenter().toPoint2D(), modelViewTransform.viewToModel(pInputEvent.getPositionRelativeTo(this.getParent()))).getAngle();
                        }

                        public void mouseDragged(PInputEvent pInputEvent) {
                            double d = this.getAngle(pInputEvent);
                            prism.rotate(d - this.previousAngle);
                            this.previousAngle = d;
                        }
                    });
                }
            }
            this.addChild(new RotationDragHandle());
        }
        this.addChild(new PhetPPath(new BasicStroke(), Color.darkGray){
            {
                super(stroke, paint);
                prism.shape.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setPathTo(modelViewTransform.modelToView(prism.shape.get().toShape()));
                    }
                });
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        Color color = ((Medium)property.get()).color;
                        this.setPaint(color);
                        Function1<Integer, Integer> function1 = new Function1<Integer, Integer>(){

                            @Override
                            public Integer apply(Integer n) {
                                return MathUtil.clamp(0, n - 28, 255);
                            }
                        };
                        this.setStrokePaint(new Color((Integer)function1.apply(color.getRed()), (Integer)function1.apply(color.getGreen()), (Integer)function1.apply(color.getBlue())));
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new CanvasBoundedDragHandler(this){

                    protected void dragNode(DragEvent dragEvent) {
                        prism.translate(modelViewTransform.viewToModelDelta(dragEvent.delta));
                    }
                });
            }
        });
    }
}

