/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.prisms;

import edu.colorado.phet.bendinglight.model.BendingLightModel;
import edu.colorado.phet.bendinglight.model.LightRay;
import edu.colorado.phet.bendinglight.model.Medium;
import edu.colorado.phet.bendinglight.model.MediumColorFactory;
import edu.colorado.phet.bendinglight.model.ProtractorModel;
import edu.colorado.phet.bendinglight.modules.prisms.Circle;
import edu.colorado.phet.bendinglight.modules.prisms.Intersection;
import edu.colorado.phet.bendinglight.modules.prisms.Polygon;
import edu.colorado.phet.bendinglight.modules.prisms.Prism;
import edu.colorado.phet.bendinglight.modules.prisms.Ray;
import edu.colorado.phet.bendinglight.modules.prisms.ShapeDifference;
import edu.colorado.phet.bendinglight.modules.prisms.ShapeIntersection;
import edu.colorado.phet.bendinglight.view.LaserColor;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrismBreakModel
extends BendingLightModel {
    private ArrayList<Prism> prisms = new ArrayList();
    public final Property<Boolean> manyRays = new Property<Boolean>(false);
    public final Property<Medium> environment = new Property<Medium>(new Medium(new Rectangle2D.Double(-1.0, 0.0, 2.0, 1.0), AIR, MediumColorFactory.getColor(AIR.getIndexOfRefractionForRedLight())));
    public final Property<Medium> prismMedium = new Property<Medium>(new Medium(new Rectangle2D.Double(-1.0, -1.0, 2.0, 1.0), GLASS, MediumColorFactory.getColor(GLASS.getIndexOfRefractionForRedLight())));
    public final Property<Boolean> showReflections = new Property<Boolean>(false);
    public final ArrayList<Intersection> intersections = new ArrayList();
    public final ArrayList<VoidFunction1<Intersection>> intersectionListeners = new ArrayList();
    private final ProtractorModel protractorModel = new ProtractorModel(0.0, 0.0);
    private final SimpleObserver updateModel = new SimpleObserver(){

        public void update() {
            PrismBreakModel.this.updateModel();
        }
    };

    public PrismBreakModel(ConstantDtClock constantDtClock) {
        super(constantDtClock, Math.PI, false, 7.3125E-6);
        new RichSimpleObserver(){

            public void update() {
                PrismBreakModel.this.updateModel();
            }
        }.observe(this.environment, this.prismMedium, this.manyRays, this.laser.color, this.showReflections);
    }

    public static ArrayList<Prism> getPrismPrototypes() {
        return new ArrayList<Prism>(){
            {
                this.add(new Prism(3, new Vector2D(), new Vector2D(0.0, 6.5000000000000004E-6), new Vector2D(6.5000000000000004E-6, 6.5000000000000004E-6), new Vector2D(6.5000000000000004E-6, 0.0)));
                this.add(new Prism(1, new Vector2D(), new Vector2D(6.5000000000000004E-6, 0.0), new Vector2D(3.2500000000000002E-6, 6.5000000000000004E-6 * Math.sqrt(3.0) / 2.0)));
                this.add(new Prism(1, new Vector2D(), new Vector2D(6.5000000000000004E-6, 0.0), new Vector2D(4.875E-6, 6.5000000000000004E-6 * Math.sqrt(3.0) / 2.0), new Vector2D(1.6250000000000001E-6, 6.5000000000000004E-6 * Math.sqrt(3.0) / 2.0)));
                double d = 3.2500000000000002E-6;
                this.add(new Prism(new Circle(new Vector2D(), d)));
                this.add(new Prism(new ShapeIntersection(new Circle(new Vector2D(), d), new Polygon(new Vector2D[]{new Vector2D(0.0, d), new Vector2D(0.0, -d), new Vector2D(-d, -d), new Vector2D(-d, d)}, 1))));
                this.add(new Prism(new ShapeDifference(new Polygon(new Vector2D[]{new Vector2D(0.0, -d), new Vector2D(d * 1.2, -d), new Vector2D(d * 1.2, d), new Vector2D(0.0, d)}, 1), new Circle(new Vector2D(), d))));
            }
        };
    }

    public void addPrism(Prism prism) {
        prism.shape.addObserver(this.updateModel);
        this.prisms.add(prism);
    }

    public void removePrism(Prism prism) {
        this.prisms.remove(prism);
        prism.shape.removeObserver(this.updateModel);
        this.updateModel();
    }

    public Iterable<? extends Prism> getPrisms() {
        return this.prisms;
    }

    private void propagate(Vector2D vector2D, Vector2D vector2D2, double d, boolean bl) {
        if (this.laser.color.get() == LaserColor.WHITE_LIGHT) {
            double d2 = 2.5000000000000002E-8;
            for (double d3 = 3.8E-7; d3 <= 7.8E-7; d3 += d2) {
                double d4 = bl ? this.prismMedium.get().getIndexOfRefraction(d3) : this.environment.get().getIndexOfRefraction(d3);
                this.propagate(new Ray(vector2D, vector2D2, d, d3, d4, 2.99792458E8 / d3), 0);
            }
        } else {
            double d5 = bl ? this.prismMedium.get().getIndexOfRefraction(this.laser.getWavelength()) : this.environment.get().getIndexOfRefraction(this.laser.getWavelength());
            this.propagate(new Ray(vector2D, vector2D2, d, this.laser.getWavelength(), d5, this.laser.getFrequency()), 0);
        }
    }

    @Override
    protected void propagateRays() {
        if (this.laser.on.get().booleanValue()) {
            Vector2D vector2D = new Vector2D(this.laser.emissionPoint.get());
            boolean bl = this.isLaserInPrism();
            Vector2D vector2D2 = this.laser.getDirectionUnitVector();
            if (!this.manyRays.get().booleanValue()) {
                this.propagate(vector2D, vector2D2, 1.0, bl);
            } else {
                for (double d = -6.5E-7; d <= 7.15E-7; d += 3.25E-7) {
                    Vector2D vector2D3 = vector2D2.getRotatedInstance(1.5707963267948966).times(d);
                    this.propagate(vector2D.plus(vector2D3), vector2D2, 1.0, bl);
                }
            }
        }
    }

    private boolean isLaserInPrism() {
        for (Prism prism : this.prisms) {
            if (!prism.contains(this.laser.emissionPoint.get())) continue;
            return true;
        }
        return false;
    }

    private void propagate(Ray ray, int n) {
        double d = 3.2500000000000002E-6;
        if (n > 50 || ray.power < 0.001) {
            return;
        }
        Intersection intersection = PrismBreakModel.getIntersection(ray, this.prisms);
        Vector2D vector2D = ray.directionUnitVector;
        double d2 = ray.mediumIndexOfRefraction;
        double d3 = ray.wavelength / d2;
        if (intersection != null) {
            this.addIntersection(intersection);
            Vector2D vector2D2 = new Vector2D(intersection.getPoint()).plus(ray.directionUnitVector.getInstanceOfMagnitude(1.0E-12));
            boolean bl = false;
            for (Prism prism : this.prisms) {
                if (!prism.contains(vector2D2)) continue;
                bl = true;
            }
            double d4 = bl ? this.prismMedium.get().getIndexOfRefraction(ray.getBaseWavelength()) : this.environment.get().getIndexOfRefraction(ray.getBaseWavelength());
            Vector2D vector2D3 = intersection.getPoint();
            Vector2D vector2D4 = intersection.getUnitNormal();
            double d5 = vector2D4.dot(vector2D.times(-1.0));
            double d6 = 1.0 - Math.pow(d2 / d4, 2.0) * (1.0 - Math.pow(d5, 2.0));
            double d7 = Math.sqrt(d6);
            boolean bl2 = d6 < 0.0;
            Vector2D vector2D5 = vector2D.plus(vector2D4.times(2.0 * d5));
            Vector2D vector2D6 = d5 > 0.0 ? vector2D.times(d2 / d4).plus(vector2D4.times(d2 / d4 * d5 - d7)) : vector2D.times(d2 / d4).plus(vector2D4.times(d2 / d4 * d5 + d7));
            double d8 = bl2 ? 1.0 : MathUtil.clamp(0.0, PrismBreakModel.getReflectedPower(d2, d4, d5, d7), 1.0);
            double d9 = bl2 ? 0.0 : MathUtil.clamp(0.0, PrismBreakModel.getTransmittedPower(d2, d4, d5, d7), 1.0);
            Ray ray2 = new Ray(vector2D3.plus(ray.directionUnitVector.times(-1.0E-12)), vector2D5, ray.power * d8, ray.wavelength, ray.mediumIndexOfRefraction, ray.frequency);
            Ray ray3 = new Ray(vector2D3.plus(ray.directionUnitVector.times(1.0E-12)), vector2D6, ray.power * d9, ray.wavelength, d4, ray.frequency);
            if (this.showReflections.get().booleanValue() || bl2) {
                this.propagate(ray2, n + 1);
            }
            this.propagate(ray3, n + 1);
            this.addRay(new LightRay(ray.tail, intersection.getPoint(), d2, d3, ray.power, new VisibleColor(ray.wavelength * 1.0E9), d, 0.0, null, true, false));
        } else {
            this.addRay(new LightRay(ray.tail, ray.tail.plus(ray.directionUnitVector.times(1.0)), d2, d3, ray.power, new VisibleColor(ray.wavelength * 1.0E9), d, 0.0, null, true, false));
        }
    }

    private void addIntersection(Intersection intersection) {
        this.intersections.add(intersection);
        for (VoidFunction1<Intersection> voidFunction1 : this.intersectionListeners) {
            voidFunction1.apply(intersection);
        }
    }

    public void addIntersectionListener(VoidFunction1<Intersection> voidFunction1) {
        this.intersectionListeners.add(voidFunction1);
    }

    private static Intersection getIntersection(final Ray ray, ArrayList<Prism> arrayList) {
        ArrayList<Intersection> arrayList2 = new ArrayList<Intersection>();
        for (Prism prism : arrayList) {
            arrayList2.addAll(prism.getIntersections(ray));
        }
        Collections.sort(arrayList2, new Comparator<Intersection>(){

            @Override
            public int compare(Intersection intersection, Intersection intersection2) {
                return Double.compare(intersection.getPoint().distance(ray.tail), intersection2.getPoint().distance(ray.tail));
            }
        });
        return arrayList2.size() == 0 ? null : (Intersection)arrayList2.get(0);
    }

    @Override
    protected void clearModel() {
        super.clearModel();
        if (this.intersections != null) {
            for (Intersection intersection : this.intersections) {
                intersection.remove();
            }
            this.intersections.clear();
        }
    }

    public ProtractorModel getProtractorModel() {
        return this.protractorModel;
    }
}

