/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.prisms;

import edu.colorado.phet.bendinglight.modules.prisms.IShape;
import edu.colorado.phet.bendinglight.modules.prisms.Intersection;
import edu.colorado.phet.bendinglight.modules.prisms.Ray;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.PolygonUtils;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
implements IShape {
    private ArrayList<Vector2D> points = new ArrayList();
    private int referencePointIndex;

    public Polygon(Vector2D[] vector2DArray, int n) {
        this(Arrays.asList(vector2DArray), n);
    }

    public Polygon(List<Vector2D> list, int n) {
        this.points = new ArrayList<Vector2D>(list);
        this.referencePointIndex = n;
    }

    @Override
    public Shape toShape() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(this.points.get(0));
        for (Vector2D vector2D : this.points.subList(1, this.points.size())) {
            doubleGeneralPath.lineTo(vector2D);
        }
        doubleGeneralPath.closePath();
        return doubleGeneralPath.getGeneralPath();
    }

    public Vector2D getPoint(int n) {
        return this.points.get(n);
    }

    @Override
    public IShape getTranslatedInstance(final double d, final double d2) {
        return new Polygon((List<Vector2D>)new ArrayList<Vector2D>(){
            {
                for (Vector2D vector2D : Polygon.this.points) {
                    this.add(vector2D.plus(d, d2));
                }
            }
        }, this.referencePointIndex);
    }

    @Override
    public ArrayList<Intersection> getIntersections(Ray ray) {
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (Line2D.Double double_ : this.getEdges()) {
            Point2D.Double double_2 = MathUtil.getLineSegmentsIntersection(double_, new Line2D.Double(ray.tail.toPoint2D(), ray.tail.plus(ray.directionUnitVector.times(1.0)).toPoint2D()));
            if (double_2 == null || Double.isNaN(double_2.getX()) || Double.isNaN(double_2.getY())) continue;
            Vector2D vector2D = new Vector2D(double_.getP1(), double_.getP2()).getRotatedInstance(1.5707963267948966).normalized();
            Vector2D vector2D2 = new Vector2D(double_.getP1(), double_.getP2()).getRotatedInstance(-1.5707963267948966).normalized();
            Vector2D vector2D3 = ray.directionUnitVector.dot(vector2D) < 0.0 ? vector2D : vector2D2;
            arrayList.add(new Intersection(vector2D3, new Vector2D(double_2)));
        }
        return arrayList;
    }

    private ArrayList<Line2D.Double> getEdges() {
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        for (int i = 0; i < this.points.size(); ++i) {
            int n = i == this.points.size() - 1 ? 0 : i + 1;
            arrayList.add(new Line2D.Double(this.points.get(i).toPoint2D(), this.points.get(n).toPoint2D()));
        }
        return arrayList;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.toShape().getBounds2D();
    }

    @Override
    public IShape getRotatedInstance(final double d, final Vector2D vector2D) {
        return new Polygon((List<Vector2D>)new ArrayList<Vector2D>(){
            {
                for (Vector2D vector2D2 : Polygon.this.points) {
                    Vector2D vector2D3 = vector2D2.minus(vector2D);
                    Vector2D vector2D4 = vector2D3.getRotatedInstance(d);
                    this.add(vector2D4.plus(vector2D));
                }
            }
        }, this.referencePointIndex);
    }

    private Point2D[] toPointArray() {
        Point2D[] point2DArray = new Point2D[this.points.size()];
        for (int i = 0; i < point2DArray.length; ++i) {
            point2DArray[i] = this.points.get(i).toPoint2D();
        }
        return point2DArray;
    }

    @Override
    public Vector2D getRotationCenter() {
        return new Vector2D(PolygonUtils.getCentroid(this.toPointArray()));
    }

    @Override
    public Option<Vector2D> getReferencePoint() {
        return new Option.Some<Vector2D>(this.getPoint(this.referencePointIndex));
    }

    @Override
    public boolean containsPoint(Vector2D vector2D) {
        return this.toShape().contains(vector2D.toPoint2D());
    }
}

