/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.prisms;

import edu.colorado.phet.bendinglight.modules.prisms.IShape;
import edu.colorado.phet.bendinglight.modules.prisms.Intersection;
import edu.colorado.phet.bendinglight.modules.prisms.Ray;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.Option;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circle
implements IShape {
    private Vector2D center;
    private double radius;

    public Circle(Vector2D vector2D, double d) {
        this.center = vector2D;
        this.radius = d;
    }

    @Override
    public Shape toShape() {
        return this.toEllipse();
    }

    private Ellipse2D.Double toEllipse() {
        return new Ellipse2D.Double(this.center.getX() - this.radius, this.center.getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
    }

    @Override
    public IShape getTranslatedInstance(double d, double d2) {
        return new Circle(this.center.plus(d, d2), this.radius);
    }

    @Override
    public ArrayList<Intersection> getIntersections(Ray ray) {
        Line2D.Double double_ = new Line2D.Double(ray.tail.toPoint2D(), ray.tail.plus(ray.directionUnitVector).toPoint2D());
        Point2D[] point2DArray = MathUtil.getLineCircleIntersection(this.toEllipse(), double_);
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (Point2D point2D : point2DArray) {
            Vector2D vector2D;
            if (point2D == null || !((vector2D = new Vector2D(point2D).minus(ray.tail)).dot(ray.directionUnitVector) > 0.0)) continue;
            Vector2D vector2D2 = new Vector2D(point2D).minus(this.center).normalized();
            if (vector2D2.dot(ray.directionUnitVector) > 0.0) {
                vector2D2 = vector2D2.negated();
            }
            arrayList.add(new Intersection(vector2D2, new Vector2D(point2D)));
        }
        return arrayList;
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.center.getX() - this.radius, this.center.getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
    }

    @Override
    public IShape getRotatedInstance(double d, Vector2D vector2D) {
        Vector2D vector2D2 = this.getRotationCenter().minus(vector2D);
        Vector2D vector2D3 = vector2D2.getRotatedInstance(d);
        return new Circle(vector2D3.plus(vector2D), this.radius);
    }

    @Override
    public Vector2D getRotationCenter() {
        return this.center;
    }

    @Override
    public Option<Vector2D> getReferencePoint() {
        return new Option.None<Vector2D>();
    }

    @Override
    public boolean containsPoint(Vector2D vector2D) {
        return vector2D.distance(this.center) <= this.radius;
    }
}

