/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.moretools;

import edu.colorado.phet.bendinglight.BendingLightApplication;
import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.modules.moretools.ChartNode;
import edu.colorado.phet.bendinglight.modules.moretools.Series;
import edu.colorado.phet.bendinglight.modules.moretools.WaveSensor;
import edu.colorado.phet.bendinglight.view.WireNode;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.CanvasBoundedDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class WaveSensorNode
extends ToolNode {
    final Color darkProbeColor = new Color(88, 89, 91);
    final Color lightProbeColor = new Color(147, 149, 152);
    private final ModelViewTransform transform;
    private final WaveSensor waveSensor;
    public final PImage bodyNode;
    public final PNode probe1Node;
    public final PNode probe2Node;

    public WaveSensorNode(final ModelViewTransform modelViewTransform, final WaveSensor waveSensor) {
        this.transform = modelViewTransform;
        this.waveSensor = waveSensor;
        final Rectangle rectangle = new Rectangle(63, 90, 37, 14);
        final Rectangle rectangle2 = new Rectangle(15, 15, 131, 68);
        this.bodyNode = new PImage(BendingLightApplication.RESOURCES.getImage("wave_detector_box.png")){
            {
                super(image);
                this.addChild(new PText(BendingLightStrings.TIME){
                    {
                        this.setFont(new PhetFont(18));
                        this.setTextPaint(Color.white);
                        this.setOffset(rectangle.getCenterX() - this.getFullBounds().getWidth() / 2.0, rectangle.getCenterY() - this.getFullBounds().getHeight() / 2.0);
                    }
                });
                this.addChild(new ChartNode(waveSensor.clock, rectangle2, new ArrayList<Series>(){
                    {
                        this.add(new Series(waveSensor.probe1.series, WaveSensorNode.this.darkProbeColor));
                        this.add(new Series(waveSensor.probe2.series, WaveSensorNode.this.lightProbeColor));
                    }
                }));
                waveSensor.bodyPosition.addObserver(new SimpleObserver(){

                    public void update() {
                        Point2D.Double double_ = modelViewTransform.modelToView(waveSensor.bodyPosition.get()).toPoint2D();
                        this.setOffset(double_.getX() - this.getFullBounds().getWidth() / 2.0, double_.getY() - this.getFullBounds().getHeight());
                    }
                });
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new CanvasBoundedDragHandler(WaveSensorNode.this){

                    protected void dragNode(DragEvent dragEvent) {
                        waveSensor.translateBody(modelViewTransform.viewToModelDelta(dragEvent.delta));
                    }
                });
            }
        };
        this.probe1Node = new ProbeNode(waveSensor.probe1, "wave_detector_probe_dark.png");
        this.probe2Node = new ProbeNode(waveSensor.probe2, "wave_detector_probe_light.png");
        this.addChild(new WireNode(this.probe1Node, this.bodyNode, this.darkProbeColor));
        this.addChild(new WireNode(this.probe2Node, this.bodyNode, this.lightProbeColor));
        this.addChild(this.bodyNode);
        this.addChild(this.probe1Node);
        this.addChild(this.probe2Node);
    }

    public void dragAll(PDimension pDimension) {
        this.waveSensor.translateAll(new Vector2D(this.transform.viewToModelDelta(pDimension)));
    }

    public PNode[] getDroppableComponents() {
        return new PNode[]{this.bodyNode, this.probe1Node, this.probe2Node};
    }

    class ProbeNode
    extends PNode {
        public ProbeNode(final WaveSensor.Probe probe, String string) {
            this.addChild(new PImage(BendingLightApplication.RESOURCES.getImage(string)));
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new CanvasBoundedDragHandler(this){

                protected void dragNode(DragEvent dragEvent) {
                    probe.translate(WaveSensorNode.this.transform.viewToModelDelta(dragEvent.delta));
                }
            });
            probe.position.addObserver(new SimpleObserver(){

                public void update() {
                    Point2D.Double double_ = WaveSensorNode.this.transform.modelToView(probe.position.get()).toPoint2D();
                    ProbeNode.this.setOffset(double_.getX() - ProbeNode.this.getFullBounds().getWidth() / 2.0, double_.getY() - ProbeNode.this.getFullBounds().getHeight() / 2.0);
                }
            });
        }
    }
}

