/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.moretools;

import edu.colorado.phet.bendinglight.modules.moretools.DataPoint;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveSensor {
    public final Probe probe1 = new Probe(-1.0000004173076924, -0.999999081923077);
    public final Probe probe2 = new Probe(-1.0000015440384615, -1.000001293653846);
    public final Property<Vector2D> bodyPosition = new Property<Vector2D>(new Vector2D(-0.9999951175, -1.0000031298076923));
    public final Clock clock;
    public final BooleanProperty visible = new BooleanProperty(false);

    public WaveSensor(final Clock clock, final Function1<Vector2D, Option<Double>> function1, final Function1<Vector2D, Option<Double>> function12) {
        this.clock = clock;
        clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                WaveSensor.this.updateProbeSample(WaveSensor.this.probe1, function1, clock);
                WaveSensor.this.updateProbeSample(WaveSensor.this.probe2, function12, clock);
            }
        });
    }

    private void updateProbeSample(Probe probe, Function1<Vector2D, Option<Double>> function1, Clock clock) {
        Option<Double> option = function1.apply(probe.position.get());
        if (option.isSome()) {
            probe.addSample(new Option.Some<DataPoint>(new DataPoint(clock.getSimulationTime(), option.get())));
        } else {
            probe.addSample(new Option.None<DataPoint>());
        }
    }

    public void translateBody(Dimension2D dimension2D) {
        this.bodyPosition.set(this.bodyPosition.get().plus(dimension2D));
    }

    public void translateToHotSpot(Point2D point2D) {
        this.translateAll(new Vector2D(point2D).minus(this.probe1.position.get()));
    }

    public void translateAll(Vector2D vector2D) {
        this.probe1.translate(vector2D);
        this.probe2.translate(vector2D);
        this.bodyPosition.set(this.bodyPosition.get().plus(vector2D));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Probe {
        public final Property<Vector2D> position;
        public final Property<ArrayList<Option<DataPoint>>> series = new Property(new ArrayList());

        public Probe(double d, double d2) {
            this.position = new Property<Vector2D>(new Vector2D(d, d2));
        }

        public void translate(Dimension2D dimension2D) {
            this.position.set(this.position.get().plus(dimension2D));
        }

        public void translate(Vector2D vector2D) {
            this.position.set(this.position.get().plus(vector2D));
        }

        public void addSample(final Option<DataPoint> option) {
            this.series.set(new ArrayList<Option<DataPoint>>((Collection)this.series.get()){
                {
                    super(collection);
                    this.add(option);
                }
            });
        }
    }
}

