/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.moretools;

import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.model.ProtractorModel;
import edu.colorado.phet.bendinglight.modules.intro.IntroCanvas;
import edu.colorado.phet.bendinglight.modules.intro.IntroModel;
import edu.colorado.phet.bendinglight.modules.moretools.ExpandableProtractorNode;
import edu.colorado.phet.bendinglight.modules.moretools.MoreToolsModel;
import edu.colorado.phet.bendinglight.modules.moretools.WaveSensor;
import edu.colorado.phet.bendinglight.modules.moretools.WaveSensorNode;
import edu.colorado.phet.bendinglight.view.BendingLightCanvas;
import edu.colorado.phet.bendinglight.view.BendingLightWavelengthControl;
import edu.colorado.phet.bendinglight.view.LaserView;
import edu.colorado.phet.bendinglight.view.ProtractorNode;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ResetModel;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Or;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.ValueEquals;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function3;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.VelocitySensor;
import edu.colorado.phet.common.piccolophet.nodes.VelocitySensorNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.NodeFactory;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolIconNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoreToolsCanvas
extends IntroCanvas<MoreToolsModel> {
    public WaveSensorNode myWaveSensorNode;
    public double arrowScale = 1.5E-14;

    public MoreToolsCanvas(MoreToolsModel moreToolsModel, BooleanProperty booleanProperty, Resettable resettable) {
        super(moreToolsModel, booleanProperty, resettable, new Function3<IntroModel, Double, Double, PNode>(){

            @Override
            public PNode apply(IntroModel introModel, final Double d, final Double d2) {
                return new BendingLightWavelengthControl(introModel.wavelengthProperty, introModel.getLaser().color){
                    {
                        super(property, property2);
                        this.setOffset(d, d2);
                    }
                };
            }
        }, 0.0, new Or(new ValueEquals<LaserView>(moreToolsModel.laserView, LaserView.WAVE), moreToolsModel.waveSensor.visible), moreToolsModel, "0.000", 6);
    }

    @Override
    protected PNode[] getMoreTools(ResetModel resetModel) {
        return new PNode[]{this.createVelocitySensorTool(resetModel), this.createWaveSensorTool(resetModel)};
    }

    private ToolIconNode<BendingLightCanvas<MoreToolsModel>> createWaveSensorTool(ResetModel resetModel) {
        Function1.Constant<Vector2D, Option<Double>> constant = new Function1.Constant<Vector2D, Option<Double>>(new Option.None());
        WaveSensor waveSensor = new WaveSensor(new ConstantDtClock(), constant, constant);
        WaveSensorNode waveSensorNode = new WaveSensorNode(this.transform, waveSensor);
        resetModel.addResetListener(new VoidFunction0(){

            public void apply() {
                ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).waveSensor.visible.reset();
            }
        });
        int n = (int)(waveSensorNode.getFullBounds().getHeight() / waveSensorNode.getFullBounds().getWidth() * 110.0);
        NodeFactory nodeFactory = new NodeFactory(){

            @Override
            public WaveSensorNode createNode(ModelViewTransform modelViewTransform, final Property<Boolean> property, Point2D point2D) {
                ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).waveSensor.probe1.position.reset();
                ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).waveSensor.probe2.position.reset();
                ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).waveSensor.bodyPosition.reset();
                ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).waveSensor.translateToHotSpot(point2D);
                if (MoreToolsCanvas.this.myWaveSensorNode == null) {
                    MoreToolsCanvas.this.myWaveSensorNode = new WaveSensorNode(modelViewTransform, ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).waveSensor){
                        {
                            super(modelViewTransform, waveSensor);
                            property.addObserver(new SimpleObserver(){

                                public void update() {
                                    this.setVisible((Boolean)property.get());
                                }
                            });
                        }
                    };
                }
                return MoreToolsCanvas.this.myWaveSensorNode;
            }
        };
        return new ToolIconNode<BendingLightCanvas<MoreToolsModel>>(waveSensorNode.toImage(110, n, new Color(0, 0, 0, 0)), ((MoreToolsModel)this.model).waveSensor.visible, this.transform, this, nodeFactory, resetModel, this.getToolboxBounds());
    }

    private ToolIconNode createVelocitySensorTool(ResetModel resetModel) {
        final Function1<Vector2D, String> function1 = new Function1<Vector2D, String>(){

            @Override
            public String apply(Vector2D vector2D) {
                String string = new DecimalFormat("0.00").format(vector2D.magnitude() / 2.99792458E8);
                return MessageFormat.format(BendingLightStrings.PATTERN_SPEED_OF_LIGHT_READOUT_VALUE_C, string);
            }
        };
        final Property<Boolean> property = new Property<Boolean>(false);
        resetModel.addResetListener(new VoidFunction0(){

            public void apply() {
                property.reset();
            }
        });
        NodeFactory nodeFactory = new NodeFactory(){

            @Override
            public VelocitySensorNode createNode(ModelViewTransform modelViewTransform, final Property<Boolean> property, Point2D point2D) {
                ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).velocitySensor.position.set(new Vector2D(point2D));
                return new VelocitySensorNode(modelViewTransform, ((MoreToolsModel)((MoreToolsCanvas)MoreToolsCanvas.this).model).velocitySensor, MoreToolsCanvas.this.arrowScale, new Property<Function1>(function1), MoreToolsCanvas.this.getBoundedConstraint(), PhetCommonResources.PICCOLO_PHET_VELOCITY_SENSOR_NODE_UNKNOWN, new Vector2D(1.0, 0.0)){
                    {
                        super(modelViewTransform, velocitySensor, d, observableProperty, function1, string, vector2D);
                        property.addObserver(new VoidFunction1<Boolean>(){

                            @Override
                            public void apply(Boolean bl) {
                                this.setVisible(bl);
                            }
                        });
                    }
                };
            }
        };
        VelocitySensorNode velocitySensorNode = new VelocitySensorNode(this.transform, new VelocitySensor(), this.arrowScale, new Property<Function1<Vector2D, String>>(function1), new Vector2D(1.0, 0.0));
        int n = (int)(velocitySensorNode.getFullBounds().getHeight() / velocitySensorNode.getFullBounds().getWidth() * 110.0);
        return new ToolIconNode<MoreToolsCanvas>(velocitySensorNode.toImage(110, n, new Color(0, 0, 0, 0)), property, this.transform, this, nodeFactory, resetModel, this.getToolboxBounds());
    }

    private Function0<Rectangle2D> getToolboxBounds() {
        return new Function0<Rectangle2D>(){

            @Override
            public Rectangle2D apply() {
                return MoreToolsCanvas.this.toolboxNode.getGlobalFullBounds();
            }
        };
    }

    @Override
    protected ProtractorNode newProtractorNode(ModelViewTransform modelViewTransform, Property<Boolean> property, Point2D point2D) {
        return new ExpandableProtractorNode(modelViewTransform, property, new ProtractorModel(point2D.getX(), point2D.getY()), this.getProtractorDragRegion(), MoreToolsCanvas.getProtractorRotationRegion(), 0.5);
    }
}

