/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.moretools;

import edu.colorado.phet.bendinglight.model.ProtractorModel;
import edu.colorado.phet.bendinglight.view.ProtractorNode;
import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Shape;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandableProtractorNode
extends ProtractorNode {
    private double originalScale;
    private Property<Boolean> expanded = new Property<Boolean>(false);

    public ExpandableProtractorNode(ModelViewTransform modelViewTransform, Property<Boolean> property, ProtractorModel protractorModel, Function2<Shape, Shape, Shape> function2, Function2<Shape, Shape, Shape> function22, double d) {
        super(modelViewTransform, property, protractorModel, function2, function22, d, 1.0);
        this.originalScale = d;
        this.addChild(new MaxMinButton(PhetCommonResources.getMaximizeButtonImage(), new Not((ObservableProperty<Boolean>)this.expanded), true));
        this.addChild(new MaxMinButton(PhetCommonResources.getMinimizeButtonImage(), this.expanded, false));
    }

    private void setExpanded(boolean bl) {
        this.expanded.set(bl);
        this.setProtractorScale(this.originalScale * (bl ? 2.3 : 1.0));
        this.updateTransform();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MaxMinButton
    extends PImage {
        MaxMinButton(BufferedImage bufferedImage, ObservableProperty<Boolean> observableProperty, final boolean bl) {
            super(bufferedImage);
            this.setScale(2.0);
            this.setOffset(ExpandableProtractorNode.this.innerBarShape.getX() + ExpandableProtractorNode.this.innerBarShape.getWidth() * 0.75 - this.getFullBounds().getWidth() / 2.0, ExpandableProtractorNode.this.innerBarShape.getCenterY() - this.getFullBounds().getHeight() / 2.0);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    ExpandableProtractorNode.this.setExpanded(bl);
                }
            });
            observableProperty.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    MaxMinButton.this.setVisible(bl);
                }
            });
        }
    }
}

