/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.moretools;

import edu.colorado.phet.bendinglight.modules.moretools.Series;
import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartNode
extends PClip {
    private final Property<ModelViewTransform> transform;
    private PNode gridLines = new PNode();
    public static int DASH_ON = 10;
    public static int DASH_OFF = 5;

    public ChartNode(final Clock clock, final Rectangle rectangle, final ArrayList<Series> arrayList) {
        this.setPathTo(rectangle);
        this.setStroke(null);
        final int n = (int)Math.ceil(400.00000000000006);
        this.transform = new Property<ModelViewTransform>(ModelViewTransform.createRectangleMapping(new Rectangle2D.Double(0.0, -1.0, 7.227222062626629E-15, 2.0), rectangle));
        this.addChild(this.gridLines);
        for (Series series : arrayList) {
            this.addChild(new SeriesNode(series));
        }
        clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                double d;
                double d2 = clock.getSimulationTime() - 7.227222062626629E-15;
                ChartNode.this.transform.set(ModelViewTransform.createRectangleMapping(new Rectangle2D.Double(d2, -1.0, 7.227222062626629E-15, 2.0), rectangle));
                ChartNode.this.gridLines.removeAllChildren();
                double d3 = 1.806805515656657E-15;
                double d4 = ChartNode.this.getDelta(d3, clock);
                for (d = d2 - d4; d <= d2 + 7.227222062626629E-15; d += 1.806805515656657E-15) {
                    ChartNode.this.addVerticalLine(d);
                }
                d = ChartNode.this.getDelta(DASH_ON + DASH_OFF, clock);
                ChartNode.this.gridLines.addChild(new GridLine(d2 - d, 0.0, d2 + 7.227222062626629E-15, 0.0, 0.0));
                for (Series series : arrayList) {
                    series.keepLastSamples(n);
                }
            }
        });
    }

    private double getDelta(double d, Clock clock) {
        double d2 = clock.getSimulationTime() / d;
        int n = (int)d2;
        return (d2 - (double)n) * d;
    }

    private void addVerticalLine(double d) {
        this.gridLines.addChild(new GridLine(d, -1.0, d, 1.0, 0.0));
    }

    public class GridLine
    extends PNode {
        public GridLine(final double d, final double d2, final double d3, final double d4, double d5) {
            this.addChild(new PhetPPath(new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{DASH_ON, DASH_OFF}, (float)d5), Color.lightGray){
                {
                    super(stroke, paint);
                    this.setPathTo(((ModelViewTransform)ChartNode.this.transform.get()).modelToView(new Line2D.Double(d, d2, d3, d4)));
                }

                public Rectangle2D getPathBoundsWithStroke() {
                    return RectangleUtils.expand(this.getPathReference().getBounds2D(), 2.0, 2.0);
                }
            });
        }
    }

    private class SeriesNode
    extends PNode {
        public SeriesNode(final Series series) {
            this.addChild(new PhetPPath(new BasicStroke(2.0f), series.getColor()){
                {
                    super(stroke, paint);
                    series.path.addObserver(new SimpleObserver(){

                        public void update() {
                            this.setPathTo(((ModelViewTransform)ChartNode.this.transform.get()).modelToView(series.toShape()));
                        }
                    });
                }
            });
        }
    }
}

