/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.intro;

import edu.colorado.phet.bendinglight.model.LightRay;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;

public class LightWaveNode
extends PNode {
    boolean debug = false;

    public LightWaveNode(final ModelViewTransform modelViewTransform, final LightRay lightRay) {
        this.addChild(new PhetPPath((Paint)this.createPaint(modelViewTransform, lightRay)){
            {
                super(paint);
                this.setPathTo(modelViewTransform.modelToView(lightRay.getWaveShape()));
                lightRay.addStepListener(new VoidFunction0(){

                    public void apply() {
                        this.setPaint(LightWaveNode.this.createPaint(modelViewTransform, lightRay));
                    }
                });
            }
        });
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    private GradientPaint createPaint(ModelViewTransform modelViewTransform, LightRay lightRay) {
        Color color;
        Color color2;
        double d = modelViewTransform.modelToViewDeltaX(lightRay.getWavelength());
        Vector2D vector2D = modelViewTransform.modelToViewDelta(lightRay.toVector2D()).normalized();
        Vector2D vector2D2 = vector2D.times(d);
        Color color3 = lightRay.getColor();
        if (this.debug) {
            color2 = new Color(1.0f, 0.0f, 0.0f, 0.5f);
            color = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        } else {
            color2 = new Color((float)color3.getRed() / 255.0f, (float)color3.getGreen() / 255.0f, (float)color3.getBlue() / 255.0f, (float)Math.sqrt(lightRay.getPowerFraction()));
            color = new Color(0.0f, 0.0f, 0.0f, (float)Math.sqrt(lightRay.getPowerFraction()));
        }
        double d2 = lightRay.getPhaseOffset() / 2.0 / Math.PI;
        Vector2D vector2D3 = vector2D.times(modelViewTransform.modelToViewDeltaX(d2 * lightRay.getWavelength()));
        float f = (float)(vector2D3.getX() + modelViewTransform.modelToViewX(lightRay.tail.getX()));
        float f2 = (float)(vector2D3.getY() + modelViewTransform.modelToViewY(lightRay.tail.getY()));
        return new GradientPaint(f, f2, color2, f + (float)vector2D2.getX() / 2.0f, f2 + (float)vector2D2.getY() / 2.0f, color, true);
    }
}

