/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.intro;

import edu.colorado.phet.bendinglight.model.BendingLightModel;
import edu.colorado.phet.bendinglight.model.IntensityMeter;
import edu.colorado.phet.bendinglight.model.LightRay;
import edu.colorado.phet.bendinglight.model.Medium;
import edu.colorado.phet.bendinglight.model.MediumColorFactory;
import edu.colorado.phet.bendinglight.model.MediumState;
import edu.colorado.phet.bendinglight.view.LaserView;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroModel
extends BendingLightModel {
    public final Property<Medium> topMedium = new Property<Medium>(new Medium(new Rectangle2D.Double(-1.0, 0.0, 2.0, 1.0), AIR, MediumColorFactory.getColor(AIR.getIndexOfRefractionForRedLight())));
    public final Property<Medium> bottomMedium;

    public IntroModel(ConstantDtClock constantDtClock, MediumState mediumState) {
        super(constantDtClock, 2.356194490192345, true, 8.125E-6);
        this.bottomMedium = new Property<Medium>(new Medium(new Rectangle2D.Double(-1.0, -1.0, 2.0, 1.0), mediumState, MediumColorFactory.getColor(mediumState.getIndexOfRefractionForRedLight())));
        new RichSimpleObserver(){

            public void update() {
                IntroModel.this.updateModel();
            }
        }.observe(this.bottomMedium, this.topMedium);
    }

    @Override
    protected void propagateRays() {
        Rectangle rectangle = new Rectangle(-10, -10, 20, 10);
        Rectangle rectangle2 = new Rectangle(-10, 0, 20, 10);
        if (this.laser.on.get().booleanValue()) {
            Vector2D vector2D = new Vector2D(this.laser.emissionPoint.get());
            double d = this.getN1();
            double d2 = this.getN2();
            double d3 = this.laser.getAngle() - 1.5707963267948966;
            double d4 = Math.asin(d / d2 * Math.sin(d3));
            double d5 = 3.2500000000000002E-6;
            double d6 = d5 / 2.0;
            Color color = this.laser.color.get().getColor();
            double d7 = this.laser.color.get().getWavelength() / d;
            LightRay lightRay = new LightRay(vector2D, new Vector2D(), d, d7, 1.0, color, d6, 0.0, rectangle, true, false);
            boolean bl = this.addAndAbsorb(lightRay);
            if (!bl) {
                double d8 = Math.asin(d2 / d);
                boolean bl2 = Double.isNaN(d8) || d3 < d8;
                double d9 = bl2 ? IntroModel.getReflectedPower(d, d2, Math.cos(d3), Math.cos(d4)) : 1.0;
                double d10 = d6;
                this.addAndAbsorb(new LightRay(new Vector2D(), Vector2D.createPolar(1.0, Math.PI - this.laser.getAngle()), d, d7, d9 * 1.0, color, d10, lightRay.getNumberOfWavelengths(), rectangle, true, false));
                if (bl2) {
                    double d11 = lightRay.getWavelength() / d2 * d;
                    if (!Double.isNaN(d4) && !Double.isInfinite(d4)) {
                        double d12 = IntroModel.getTransmittedPower(d, d2, Math.cos(d3), Math.cos(d4));
                        double d13 = d5 / 2.0;
                        double d14 = d13 / Math.sin(1.5707963267948966 - d3) / 2.0;
                        double d15 = Math.cos(d4) * d14;
                        double d16 = d15 * 2.0;
                        LightRay lightRay2 = new LightRay(new Vector2D(), Vector2D.createPolar(1.0, d4 - 1.5707963267948966), d2, d11, d12 * 1.0, color, d16, lightRay.getNumberOfWavelengths(), rectangle2, true, true);
                        this.addAndAbsorb(lightRay2);
                    }
                }
            }
            lightRay.moveToFront();
        }
    }

    private double getN1() {
        return this.topMedium.get().getIndexOfRefraction(this.laser.color.get().getWavelength());
    }

    private double getN2() {
        return this.bottomMedium.get().getIndexOfRefraction(this.laser.color.get().getWavelength());
    }

    protected boolean addAndAbsorb(LightRay lightRay) {
        boolean bl;
        boolean bl2 = bl = lightRay.intersects(this.intensityMeter.getSensorShape()) && this.intensityMeter.enabled.get() != false;
        if (bl) {
            Point2D[] point2DArray = MathUtil.getLineCircleIntersection(this.intensityMeter.getSensorShape(), lightRay.toLine2D());
            if (point2DArray != null && point2DArray[0] != null && point2DArray[1] != null) {
                boolean bl3;
                double d = point2DArray[0].getX() + point2DArray[1].getX();
                double d2 = point2DArray[0].getY() + point2DArray[1].getY();
                LightRay lightRay2 = new LightRay(lightRay.tail, new Vector2D(d / 2.0, d2 / 2.0), lightRay.indexOfRefraction, lightRay.getWavelength(), lightRay.getPowerFraction(), this.laser.color.get().getColor(), lightRay.getWaveWidth(), lightRay.getNumWavelengthsPhaseOffset(), lightRay.getOppositeMedium(), false, lightRay.extendBackwards);
                boolean bl4 = bl3 = lightRay.toVector2D().dot(lightRay2.toVector2D()) > 0.0;
                if (lightRay2.getLength() < lightRay.getLength() && bl3) {
                    this.addRay(lightRay2);
                } else {
                    this.addRay(lightRay);
                    bl = false;
                }
            }
        } else {
            this.addRay(lightRay);
        }
        if (bl) {
            this.intensityMeter.addRayReading(new IntensityMeter.Reading(lightRay.getPowerFraction()));
        } else {
            this.intensityMeter.addRayReading(IntensityMeter.Reading.MISS);
        }
        return bl;
    }

    protected Option<Vector2D> getVelocity(Vector2D vector2D) {
        for (LightRay lightRay : this.rays) {
            if (!lightRay.contains(vector2D, this.laserView.get() == LaserView.WAVE)) continue;
            return new Option.Some<Vector2D>(lightRay.getVelocityVector());
        }
        return new Option.None<Vector2D>();
    }

    protected Option<Double> getWaveValue(Vector2D vector2D) {
        for (LightRay lightRay : this.rays) {
            if (!lightRay.contains(vector2D, this.laserView.get() == LaserView.WAVE)) continue;
            double d = Math.sqrt(lightRay.getPowerFraction());
            double d2 = lightRay.getUnitVector().dot(new Vector2D(lightRay.tail.toPoint2D(), vector2D.toPoint2D()));
            double d3 = lightRay.getCosArg(d2);
            return new Option.Some<Double>(d * Math.cos(d3 + Math.PI));
        }
        return new Option.None<Double>();
    }
}

