/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.intro;

import edu.colorado.phet.bendinglight.BendingLightApplication;
import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.model.BendingLightModel;
import edu.colorado.phet.bendinglight.model.ProtractorModel;
import edu.colorado.phet.bendinglight.modules.intro.IntroModel;
import edu.colorado.phet.bendinglight.modules.intro.NormalLine;
import edu.colorado.phet.bendinglight.view.BendingLightCanvas;
import edu.colorado.phet.bendinglight.view.BendingLightResetAllButtonNode;
import edu.colorado.phet.bendinglight.view.LaserView;
import edu.colorado.phet.bendinglight.view.MediumControlPanel;
import edu.colorado.phet.bendinglight.view.MediumNode;
import edu.colorado.phet.bendinglight.view.ProtractorNode;
import edu.colorado.phet.bendinglight.view.ToolboxNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.ResetModel;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.Function3;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.SimSpeedControlPNode;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.NodeFactory;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolIconNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroCanvas<T extends IntroModel>
extends BendingLightCanvas<T> {
    public final ToolboxNode toolboxNode;

    public IntroCanvas(T t, BooleanProperty booleanProperty, Resettable resettable, Function3<IntroModel, Double, Double, PNode> function3, double d, final ObservableProperty<Boolean> observableProperty, ResetModel resetModel, String string, int n) {
        super(t, booleanProperty, new Function1<Double, Double>(){

            @Override
            public Double apply(Double d) {
                while (d < 0.0) {
                    d = d + Math.PI * 2;
                }
                return MathUtil.clamp(1.5707963267948966, d, Math.PI);
            }
        }, new Function1<Double, Boolean>(){

            @Override
            public Boolean apply(Double d) {
                return d < Math.PI;
            }
        }, new Function1<Double, Boolean>(){

            @Override
            public Boolean apply(Double d) {
                return d > 1.5707963267948966;
            }
        }, true, IntroCanvas.getProtractorRotationRegion(), new Function2<Shape, Shape, Shape>(){

            @Override
            public Shape apply(Shape shape, Shape shape2) {
                return shape;
            }
        }, "laser.png", d);
        this.mediumNode.addChild(new MediumNode(this.transform, ((IntroModel)t).topMedium));
        this.mediumNode.addChild(new MediumNode(this.transform, ((IntroModel)t).bottomMedium));
        this.afterLightLayer2.addChild(new ControlPanelNode((PNode)new MediumControlPanel(this, ((IntroModel)t).topMedium, BendingLightStrings.MATERIAL, true, ((IntroModel)t).wavelengthProperty, string, n)){
            {
                this.setOffset(((IntroCanvas)IntroCanvas.this).stageSize.width - this.getFullBounds().getWidth() - 10.0, IntroCanvas.this.transform.modelToViewY(0.0) - 10.0 - this.getFullBounds().getHeight());
            }
        });
        this.afterLightLayer2.addChild(new ControlPanelNode((PNode)new MediumControlPanel(this, ((IntroModel)t).bottomMedium, BendingLightStrings.MATERIAL, true, ((IntroModel)t).wavelengthProperty, string, n)){
            {
                this.setOffset(((IntroCanvas)IntroCanvas.this).stageSize.width - this.getFullBounds().getWidth() - 10.0, IntroCanvas.this.transform.modelToViewY(0.0) + 10.0);
            }
        });
        this.beforeLightLayer.addChild(new PhetPPath(this.transform.modelToView(new Line2D.Double(-1.0, 0.0, 1.0, 0.0)), (Stroke)new BasicStroke(0.5f), (Paint)Color.gray){
            {
                this.setPickable(false);
            }
        });
        this.afterLightLayer2.addChild(new NormalLine(this.transform, ((BendingLightModel)t).getHeight()){
            {
                IntroCanvas.this.showNormal.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
            }
        });
        PNode pNode = new PNode((IntroModel)t, function3){
            final /* synthetic */ IntroModel val$model;
            final /* synthetic */ Function3 val$additionalLaserControls;
            {
                this.val$model = introModel;
                this.val$additionalLaserControls = function3;
                final PText pText = new PText(BendingLightStrings.LASER_VIEW){
                    {
                        this.setFont(BendingLightCanvas.labelFont);
                    }
                };
                this.addChild(pText);
                PSwing pSwing = new PSwing(new VerticalLayoutPanel(){
                    {
                        this.add(new PropertyRadioButton<LaserView>(BendingLightStrings.RAY, (SettableProperty)val$model.laserView, LaserView.RAY){
                            {
                                this.setFont(BendingLightCanvas.labelFont);
                            }
                        });
                        this.add(new PropertyRadioButton<LaserView>(BendingLightStrings.WAVE, (SettableProperty)val$model.laserView, LaserView.WAVE){
                            {
                                this.setFont(BendingLightCanvas.labelFont);
                            }
                        });
                    }
                }){
                    {
                        super(jComponent);
                        this.setOffset(0.0, pText.getFullBounds().getMaxY());
                    }
                };
                this.addChild(pSwing);
                PNode pNode = (PNode)this.val$additionalLaserControls.apply(this.val$model, 0.0, pSwing.getFullBounds().getMaxY() + 5.0);
                this.addChild(pNode);
            }
        };
        ControlPanelNode controlPanelNode = new ControlPanelNode(pNode);
        controlPanelNode.setOffset(5.0, 5.0);
        this.afterLightLayer2.addChild(controlPanelNode);
        NodeFactory nodeFactory = new NodeFactory(){

            @Override
            public ProtractorNode createNode(ModelViewTransform modelViewTransform, Property<Boolean> property, Point2D point2D) {
                return IntroCanvas.this.newProtractorNode(modelViewTransform, property, point2D);
            }
        };
        ToolIconNode toolIconNode = new ToolIconNode<BendingLightCanvas<T>>(BufferedImageUtils.multiScaleToWidth(BendingLightApplication.RESOURCES.getImage("protractor.png"), 110), this.showProtractor, this.transform, this, nodeFactory, (ResetModel)t, new Function0<Rectangle2D>(){

            @Override
            public Rectangle2D apply() {
                return IntroCanvas.this.toolboxNode.getGlobalFullBounds();
            }
        }){

            @Override
            protected void addChild(BendingLightCanvas<T> bendingLightCanvas, ToolNode toolNode) {
                bendingLightCanvas.addChildAfterLight(toolNode);
            }

            @Override
            protected void removeChild(BendingLightCanvas<T> bendingLightCanvas, ToolNode toolNode) {
                bendingLightCanvas.removeChildAfterLight(toolNode);
            }
        };
        this.toolboxNode = new ToolboxNode(this, this.transform, (PNode)toolIconNode, this.getMoreTools((ResetModel)t), ((BendingLightModel)t).getIntensityMeter(), this.showNormal);
        ControlPanelNode controlPanelNode2 = new ControlPanelNode((PNode)this.toolboxNode){
            {
                this.setOffset(10.0, ((IntroCanvas)IntroCanvas.this).stageSize.height - this.getFullBounds().getHeight() - 10.0);
            }
        };
        this.beforeLightLayer.addChild(controlPanelNode2);
        this.afterLightLayer2.addChild(new BendingLightResetAllButtonNode(resettable, this, this.stageSize));
        this.afterLightLayer2.addChild(new FloatingClockControlNode(this.playing, null, ((BendingLightModel)t).getClock(), BendingLightStrings.RESET, new Property<Color>(Color.white), (IntroModel)t, resetModel, controlPanelNode2){
            final /* synthetic */ IntroModel val$model;
            final /* synthetic */ ResetModel val$resetModel;
            final /* synthetic */ ControlPanelNode val$toolbox;
            {
                this.val$model = introModel;
                this.val$resetModel = resetModel;
                this.val$toolbox = controlPanelNode;
                super(settableProperty, function1, iClock, string, observableProperty3);
                observableProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
                double d = this.val$model.getClock().getDt();
                Property<Double> property = new Property<Double>(Double.valueOf(d)){
                    {
                        this.addObserver(new SimpleObserver(){

                            public void update() {
                                val$model.getClock().setDt((Double)this.get());
                            }
                        });
                        val$resetModel.addResetListener(new VoidFunction0(){

                            public void apply() {
                                this.reset();
                            }
                        });
                    }
                };
                SimSpeedControlPNode simSpeedControlPNode = new SimSpeedControlPNode(1.806805515656657E-17, property, 1.806805515656657E-16, 0.0, new Property<Color>(Color.black));
                this.addChild(simSpeedControlPNode);
                this.setOffset(this.val$toolbox.getFullBounds().getMaxX() + simSpeedControlPNode.getFullBounds().getWidth() + 10.0, IntroCanvas.this.stageSize.getHeight() - this.getFullBounds().getHeight());
            }
        });
    }

    protected PNode[] getMoreTools(ResetModel resetModel) {
        return new PNode[0];
    }

    protected ProtractorNode newProtractorNode(ModelViewTransform modelViewTransform, Property<Boolean> property, Point2D point2D) {
        return new ProtractorNode(modelViewTransform, property, new ProtractorModel(point2D.getX(), point2D.getY()), this.getProtractorDragRegion(), IntroCanvas.getProtractorRotationRegion(), 0.5, 1.0);
    }

    protected static Function2<Shape, Shape, Shape> getProtractorRotationRegion() {
        return new Function2<Shape, Shape, Shape>(){

            @Override
            public Shape apply(Shape shape, Shape shape2) {
                return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
        };
    }

    protected Function2<Shape, Shape, Shape> getProtractorDragRegion() {
        return new Function2<Shape, Shape, Shape>(){

            @Override
            public Shape apply(Shape shape, final Shape shape2) {
                return new Area(shape){
                    {
                        super(shape);
                        this.add(new Area(shape2));
                    }
                };
            }
        };
    }
}

