/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.modules.intro;

import edu.colorado.phet.bendinglight.model.IntensityMeter;
import edu.colorado.phet.bendinglight.view.BendingLightCanvas;
import edu.colorado.phet.bendinglight.view.IntensityMeterNode;
import edu.colorado.phet.bendinglight.view.ToolboxNode;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ResetModel;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.NodeFactory;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolIconNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntensitySensorTool
extends ToolIconNode<BendingLightCanvas> {
    public IntensitySensorTool(BendingLightCanvas bendingLightCanvas, ModelViewTransform modelViewTransform, final IntensityMeter intensityMeter, final double d, final double d2, final ToolboxNode toolboxNode, IntensityMeterNode intensityMeterNode, int n) {
        super(intensityMeterNode.toImage(110, n, new Color(0, 0, 0, 0)), intensityMeter.enabled, modelViewTransform, bendingLightCanvas, new NodeFactory(){

            @Override
            public IntensityMeterNode createNode(ModelViewTransform modelViewTransform, Property<Boolean> property, final Point2D point2D) {
                return new IntensityMeterNode(modelViewTransform, intensityMeter){
                    {
                        super(modelViewTransform, intensityMeter);
                        intensityMeter.sensorPosition.set(new Vector2D(d * 0.3, -d2 * 0.3));
                        intensityMeter.bodyPosition.set(new Vector2D(d * 0.4, -d2 * 0.3));
                        Vector2D vector2D = new Vector2D(point2D).minus(intensityMeter.sensorPosition.get());
                        intensityMeter.translateAll(new PDimension(vector2D.getX(), vector2D.getY()));
                    }
                };
            }
        }, (ResetModel)bendingLightCanvas.getModel(), new Function0<Rectangle2D>(){

            @Override
            public Rectangle2D apply() {
                return toolboxNode.getGlobalFullBounds();
            }
        });
    }

    @Override
    protected void addChild(BendingLightCanvas bendingLightCanvas, ToolNode toolNode) {
        bendingLightCanvas.addChildBehindLight(toolNode);
    }

    @Override
    protected void removeChild(BendingLightCanvas bendingLightCanvas, ToolNode toolNode) {
        bendingLightCanvas.removeChildBehindLight(toolNode);
    }
}

