/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.model;

import edu.colorado.phet.bendinglight.model.BendingLightModel;
import edu.colorado.phet.common.phetcommon.math.Function;
import java.awt.Color;

public class MediumColorFactory {
    public static final Color AIR_COLOR = Color.white;
    public static final Color WATER_COLOR = new Color(198, 226, 246);
    public static final Color GLASS_COLOR = new Color(171, 169, 212);
    public static final Color DIAMOND_COLOR = new Color(78, 79, 164);

    public static Color getColor(double d) {
        double d2 = BendingLightModel.WATER.getIndexOfRefractionForRedLight();
        double d3 = BendingLightModel.GLASS.getIndexOfRefractionForRedLight();
        double d4 = BendingLightModel.DIAMOND.getIndexOfRefractionForRedLight();
        if (d < d2) {
            double d5 = new Function.LinearFunction(1.0, d2, 0.0, 1.0).evaluate(d);
            return MediumColorFactory.colorBlend(AIR_COLOR, WATER_COLOR, d5);
        }
        if (d < d3) {
            double d6 = new Function.LinearFunction(d2, d3, 0.0, 1.0).evaluate(d);
            return MediumColorFactory.colorBlend(WATER_COLOR, GLASS_COLOR, d6);
        }
        if (d < d4) {
            double d7 = new Function.LinearFunction(d3, d4, 0.0, 1.0).evaluate(d);
            return MediumColorFactory.colorBlend(GLASS_COLOR, DIAMOND_COLOR, d7);
        }
        return DIAMOND_COLOR;
    }

    private static Color colorBlend(Color color, Color color2, double d) {
        return new Color(MediumColorFactory.clamp((int)((double)color.getRed() * (1.0 - d) + (double)color2.getRed() * d)), MediumColorFactory.clamp((int)((double)color.getGreen() * (1.0 - d) + (double)color2.getGreen() * d)), MediumColorFactory.clamp((int)((double)color.getBlue() * (1.0 - d) + (double)color2.getBlue() * d)), MediumColorFactory.clamp((int)((double)color.getAlpha() * (1.0 - d) + (double)color2.getAlpha() * d)));
    }

    private static int clamp(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }
}

